<?php
/*
Plugin Name:  Event EW plugin
Plugin URI: http://emberware.it/
Description: Emberware event plugin
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/
define( 'PATH_EVENT_PLUGIN', plugin_dir_path( __FILE__ ) );

// wp_register_script( 'custom', MY_PLUGIN_URL . 'js/custom.js', array( 'jquery' ), '1.0', true );

if (! class_exists ('EW_EVENT_PLUGIN')){
    /**
     * Gestione con pagina eventi con select a cascata
     */
    class EW_EVENT_PLUGIN {

        public function load_events(){
            global $current_user;
            get_currentuserinfo();
        
            if ($_GET["municipality"])
                $municipality_searched = $_GET["municipality"];
            if ($_GET["zone"])
                $zone_searched = $_GET["zone"];
        
            // List of municipality
            $municipality_terms = get_terms( array(
                'taxonomy' => 'municipality',
                'parent' => '0'
            ));
            
            echo "<div class='container-fluid'>";
                echo "<div class='row'>";
                    echo "<div class='col-md-3 col-sm-8 col-xs-8'>";
                        echo "<div class='row'>";			
                            echo "<div class='col-md-12'>";
                                echo "<br><h3>Seleziona la città</h3>";

                                echo "<form ><input type=\"hidden\" name=\"page\" value=\"gestione-eventi\">";
                                    echo "<select class='municipality form-control'  name=\"municipality\">";
                                        echo "<option value=''>-- Seleziona la città --</option>";
                                        foreach($municipality_terms as $municipality){
                                            if($municipality_searched == $municipality->slug){
                                                $selected = "selected = 'selected'";
                                                $municipality_id = $municipality->term_id;
                                                $municipality_name = $municipality->name;
                                                $municipality_slug = $municipality->slug;
                                            }else{
                                                $selected = "";
                                            }
                                            echo "<option ".$selected ." value='".$municipality->slug."'>".$municipality->name."</option>";
                                        }
                                    echo "</select>";
                                    echo "<input class='btn btn-primary' type='submit' value='Cerca'> ";
                                    echo "<a href='?page=gestione-eventi' class='btn btn-danger' type='button' value='Reset'>Reset</a>
                                </form>";
                            echo "</div>";
                        echo "</div>";
                    echo "</div>";
                    

                    if ($municipality_searched){
                        echo "<div class='col-md-3 col-sm-8 col-xs-8'>";
                            echo "<div class='row'>";			
                                echo "<div class='col-md-12'>";
                                    echo "<br><h3>Seleziona la zona</h3>";

                                    // List of zone
                                    $zone_terms = get_terms( array(
                                        'taxonomy' => 'municipality',
                                        'parent' => $municipality_id,
                                        'hide_empty' => false
                                    ));

                                    if(!empty($zone_terms)){
                                        echo "<form><input type=\"hidden\" name=\"page\" value=\"gestione-eventi\">";
                                        echo "<input name='municipality' type='hidden' value='".$municipality_slug."'>";
                                        foreach($zone_terms as $zone){
                                            if($zone_searched == $zone->slug){
                                                $zone_id = $zone->term_id;
                                                $sel_zone = "style='display:block;background:grey;color:white'";
                                            }else{
                                                $sel_zone = "style='display:block;'";
                                            }
                                            
                                            echo "<button class='btn btn-default btn-block btn-event' ".$sel_zone." name='zone' type='submit' value='".$zone->slug."'>".$zone->name."</button><br> ";
                                        }
                                        echo "</form>";
                                        
                                    }else{
                                        echo "<p>Nessuna zona disponibile!</p>";
                                    }
                                echo "</div>";
                            echo "</div>";    
                        echo "</div>";    
                    }
    
                    if($zone_searched){
                        echo "<div class='col-md-6 col-sm-8 col-xs-9'>";
                            echo "<div class='row'>";			
                                echo "<div class='col-md-12'>";
                                    echo "<br><h3>Seleziona la raccolta</h3>";
                                    // $bin_type_ids = wp_get_post_terms( $garbage_type_id, 'bin_type', array('fields'=> 'ids') );
                        
                                    $args = array(
                                        'post_type' => 'tribe_events',
                                        'posts_per_page'   => -1,
                                        'post_parent' => '0',
                                        'fields' => 'ID',
                                        'tax_query' =>array(
                                            'relation' => '=',
                                            array(
                                                'taxonomy' => 'municipality',
                                                'field'    => 'term_id',
                                                'terms'    => $zone_id,
                                            ),
                                        )
                                    );
                                    $events =  get_posts($args);

                                    $arr_bins = array();
                                    if(!empty($events)){
                                        foreach($events as $event){
                                            
                                            $bins_type = get_the_terms($event, 'bin_type');
                                            $link = get_edit_post_link($event->ID);
                                            $delete = get_delete_post_link($event->ID);
                                              

                                            foreach($bins_type as $bin){
                                                array_push($arr_bins, $bin->term_id);                 
                                                // get field garbage center bin type
                                                $garbage_center = get_term_meta($bin->term_id, 'garbage_center', true);

                                                array_push($arr_bins, $bin->term_id);                 
                                                echo "<div class='row'>";			
                                                    echo "<div class='col-lg-8 col-md-8 col-sm-9 col-xs-8'>";			
                                                        echo "<div class='div-event'>".$bin->name."</div>";	
                                                    echo "</div>";
                                                    echo "<div class='col-lg-3 col-md-4 col-sm-3 col-xs-4'>";	
                                                        if($garbage_center != "1"){
                                                            echo "<a class='edit-event btn btn-warning' href='".$link."' target='black'><i class='fa fa-pencil'></i></a>";
                                                        }
                                                        echo "<a class='delete-event btn btn-danger' href='".$delete."'><i class='fa fa-trash'></i></a><br>";
                                                    echo "</div>";
                                                echo "</div>";			
                                            }                                        
                                        }
                                    }else{
                                        echo "<p>Non ci sono raccolte per questa zona.</p>";
                                    }
                                echo "</div>";
                            echo "</div>";

                            // List of bin
                            $bins_terms = get_terms( array(
                                'taxonomy' => 'bin_type',
                                'parent' => '0',
                                'hide_empty' => false
                            ));

                            $arr_newbin = array();
                            
                            foreach($bins_terms as $bin_terms){
                                array_push($arr_newbin, $bin_terms->term_id);   
                            }
                            $result = array_diff($arr_newbin, $arr_bins);

                            echo "<div class='row'>";			
                                echo "<div class='col-md-12'>";
                                    echo "<h5>La raccolta non è nell'elenco? Creala.</h5>";	
                                echo "</div>";		
                            echo "</div>";		
                            echo "<div class='row'>";		
                                echo "<div class='col-lg-8 col-md-8 col-sm-9 col-xs-8'>";		
                                    echo "<select class='newevent form-control'  name='newevent''>";
                                        echo "<option value=''>-- Seleziona la raccolta --</option>";
                                        foreach($result as $new_event){
                                            $term = get_term($new_event);
                                            echo "<option value='".$term->term_id."'>".$term->name."</option>";
                                        }
                                    echo "</select>";
                                echo "</div>";
                                echo "<div class='col-lg-2 col-md-3 col-sm-3 col-xs-3'>";	
                                    echo "<input type='hidden' class='bin-new' value='' >";
                                    echo "<input type='hidden' class='zone-new' value='".$zone_id."' >";
                                    echo "<a href='#' id='create-event' class='btn btn-success btn-block' type='submit'>Crea</a><br> ";
                                echo "</div>";
                            echo "</div>";	
                        echo "</div>";  	
                    }
                echo "</div>";
            echo "</div>";
            
                   
        }
        
        function Eventi_menu ()
        {
            add_menu_page('Gestione eventi', 'Gestione eventi', 'manage_options', 'gestione-eventi', null);
            add_submenu_page( 'gestione-eventi', 'Gestione eventi', 'Gestione eventi', 'manage_options', 'gestione-eventi', array( __CLASS__, 'load_events') );
        }

        public static function init(){            
            add_action('admin_menu', array( __CLASS__, 'Eventi_menu' ));
        }
    }

}
add_action ('plugins_loaded', array('EW_EVENT_PLUGIN', 'init'));

/**
 * Register and enqueue a custom stylesheet in the WordPress admin.
 */
function load_custom_wp_admin_style($hook) {

    $current_screen = get_current_screen();

    if ( strpos($current_screen->base, 'gestione-eventi') === false) {
        return;
    }else{
        //css included
        wp_enqueue_style( 'bootstrap_css', 'https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css', false, '3.4.1' );
        wp_enqueue_style( 'bootstrap_theme_css', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap-theme.min.css', false, '3.3.7' );
        wp_enqueue_style( 'select2_css', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.2/css/select2.min.css', false, '4.0.2' );
        wp_enqueue_style( 'bootstrap_theme_select2_css', 'https://select2.github.io/select2-bootstrap-theme/css/select2-bootstrap.css', false, '1.0.0' );
        wp_enqueue_style( 'bootstrap_fontawesome_css', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', false, '1.0.0' );
        wp_enqueue_style( 'custom_wp_admin_css', plugin_dir_url( __FILE__ )  . '/css/style.css', false, '1.0.0' );

        //js included
        wp_enqueue_script( 'bootstrap_js', 'https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js', array(), '3.4.1' );
        wp_enqueue_script( 'select2_js', 'https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.2/js/select2.min.js', array(), '4.0.2' );
        wp_enqueue_script( 'custom_wp_admin_js', plugin_dir_url( __FILE__ ) . '/js/custom.js', array(), '1.0' );
    }  
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );

function create_event() {
    $event = wp_insert_post(
        array(
            'post_title'    => time(),
            'post_status'   => 'publish',
            'post_author'   => 1,
            'post_type' => 'tribe_events',
        )
    );
    wp_set_post_terms($event, $_POST['bin'], 'bin_type');
    wp_set_post_terms($event, $_POST['zone'], 'municipality');
} 
add_action('wp_ajax_create-post', 'create_event');


/**
 * Adds a box to the edit post event
 */
function add_metbox_path() {
    global $post;

    add_meta_box(
        'awesome_metabox_id',
        'Raccolta',
        'render_metabox_path',
        'tribe_events',
        'custom-metabox-path'    //Look what we have here, a new context
    );
}
add_action( 'add_meta_boxes', 'add_metbox_path' );

function create_metbox_path( $post ) {    
    global $post, $wp_meta_boxes;
    do_meta_boxes( null, 'custom-metabox-path', $post );
}
add_action( 'edit_form_after_title', 'create_metbox_path' );


add_action('admin_init', 'wpse_110427_hide_title');
function wpse_110427_hide_title() {
    remove_post_type_support('tribe_events', 'title');
}

 
function render_metabox_path( $post ) {

    $path = "";
    // Format: Cremona > Porta a porta zona 1 > Carta e cartone
    $zones = get_the_terms($post->ID, 'municipality');
    $bins_type = get_the_terms($post, 'bin_type');
   
    foreach($zones as $zone){
        
        $city_id = $zone->parent;
        $city = get_term($city_id);

        $path .= $city->name;
        $path .= " > ".$zone->name;
    }

    foreach($bins_type as $bin){
        $path .= " > ".$bin->name;
    }
    echo "<h3>" . $path . "</h3>"; 
}
?>