<?php
/*
Plugin Name: Event API plugin
Plugin URI: http://emberware.it/
Description: Event API plugin
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (! class_exists ('EW_EVENT_API')){
    class EW_EVENT_API{
        public static function register_routes() {
            $version = '1';
            $namespace = 'ee/v' . $version;
            register_rest_route($namespace, 'garbages/(?P<id>\d+)', array(
                'methods' => 'GET',
                'callback' => 'rest_get_garbages',
                )
            );
            register_rest_route($namespace, 'garbage-collections', array(
                'methods' => 'GET',
                'callback' => 'rest_get_garbage_collections',
                )
            );
        }
        public static function init(){
            add_action( 'rest_api_init', array( __CLASS__, 'register_routes' ), 12 );
        }
    }
}
add_action ('plugins_loaded', array('EW_EVENT_API', 'init'));

/**
 * Returns all collection events for the next 15 days in a particular area 
 * by the id of a specific garbage
 */
function rest_get_garbages($request){
    $bin_array = array();
    $arrBin = array();
    $parent = 0;

    //default values
    $list_events = null;
    $container_type = null;

    // get zone-id from header
    $zone_id = $request->get_header( 'zone-id' );
   
    // set the date range from today to the next 15 days
    $day = 15;
    $start_date = date('Y-m-d');
    
    $end_date = date('Y-m-d',strtotime ("+".$day." day"));

    $garbage_id = (int)$request->get_param( 'id' );
    $garbage = get_post($garbage_id);

    // get garbage type from garbage id
    $garbage_type_id = get_post_meta( $garbage_id, 'garbage_type', true );

    // get bin type type from garbage type id
    $bin_type_ids = wp_get_post_terms( $garbage_type_id, 'bin_type', array('fields'=> 'ids') );

    $garbage_type = garbage_type_str($garbage_type_id);

    // //query for list of tribe events 
    $event_args = array(
        'post_type' => 'tribe_events',
        'posts_per_page' => -1,
        'start_date' => $start_date,
        'end_date' => $end_date,
        'tax_query' => array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'municipality',
                'field'    => 'term_id',
                'terms'    => $zone_id,
            ),
            array(
                'taxonomy' => 'bin_type',
                'field'    => 'term_id',
                'terms'    => $bin_type_ids,
            ),
        )
    );

    $tribe_events = tribe_get_events($event_args);
    
    if(!empty($tribe_events)){
        $list_events = event_str($tribe_events);  
    }

    $bins_type = get_the_terms($garbage_type_id, 'bin_type');
    if (!empty($bins_type)) {
        foreach ($bins_type as $bin_type) {
            $bin_array = array(
                'term_id' =>  $bin_type->term_id,
                'name' =>  $bin_type->name
            );
            array_push($arrBin, $bin_array);
        }
        $container_type = bin_type_str($arrBin);
    }
    

    // API response 
    $arrGarbageEvents = array(
        'title' => array(
            'rendered' => $garbage->post_title
        ),
        'id' => $garbage_id,
        'slug' => $garbage->post_name,
        'content' => array(
            'rendered' => $garbage->post_content
        ),
        'garbage-type' => $garbage_type,
        'garbage-collection-events' => $list_events,
        'container-type' =>  $container_type 

    );
   
    return new WP_REST_Response ($arrGarbageEvents, 200);
}

/**
 * Function of returns all collection events for the next 15 days in a particular area
 */
function rest_get_garbage_collections($request){

    $list_events = array();
    // // get zone-id from header
    $zone_id = $request->get_header( 'zone-id' );    

    // set the date range from today to the next 15 days
    $day = 15;
    $start_date = date('Y-m-d');
    $end_date = date('Y-m-d',strtotime ("+".$day." day"));

    // //query for list of tribe events 
    $event_args = array(
        'post_type' => 'tribe_events',
        'posts_per_page' => -1,
        'start_date' => $start_date,
        'end_date' => $end_date,
        'tax_query' => array(
            'relation' => '=',
            array(
                'taxonomy' => 'municipality',
                'field'    => 'term_id',
                'terms'    => $zone_id,
            ),
        )
    );

    
    $tribe_events = tribe_get_events($event_args);
     
    //format list of events
    if(!empty($tribe_events)){
        $list_events = event_str($tribe_events);                  
    }
    
    return new WP_REST_Response ($list_events, 200);
}

/**
 * Function for format the event element
 */
function event_str($tribe_events){
    $arrEvents = array();
    $arrBin = array();

    if(!empty($tribe_events)){
        foreach($tribe_events as $event_tribe){

            $event_id = $event_tribe->ID;
            
            // get event date start 
            $date = get_post_meta( $event_tribe->ID, '_EventStartDate', true);
            $event_date = date('Y-m-d', strtotime($date));
    
            // get event date end 
            $time_end = get_post_meta( $event_tribe->ID, '_EventEndDate', true);
            $time_event = date('H:i', strtotime($time_end));
            $time_control = date('12:00');

            if($time_event > $time_control){
                $time_day = "";
            }else{
                $time_day = " del mattino";
            }
    
            // load bin type and format array bin type
            $bins_type = get_the_terms($event_id, 'bin_type');  
            foreach($bins_type as $bin_type){
                $bin_array = array(
                    'term_id' =>  $bin_type->term_id,
                    'name' =>  $bin_type->name
                );
            } 
            array_push($arrBin, $bin_array);
    
            $container_type = bin_type_str($arrBin);
    
            // load zone
            $zones = get_the_terms($event_id, 'municipality');
            foreach($zones as $zone){
                $zone_id =  $zone->term_id;
            }  

            if(!empty($event_tribe->post_content)){
                $description = $event_tribe->post_content." Esporre i rifiuti entro le ore ".$time_event.$time_day;
            }else{
                $description = "Esporre i rifiuti entro le ore ".$time_event.$time_day;
            }
    
            // create array event element
            $event_element = array(
                'id' => $event_tribe->ID,
                'date' => $event_date,
                'container-type' => $container_type,
                'description' => $description,
                'zone-id' => $zone_id
            );
    
            //add event element to array event
            array_push($arrEvents, $event_element);
        }
    }

    return $arrEvents;
}

/**
 * Function for format the bin type element
 */
function bin_type_str($arrBin){
    $container_type = array();
    $icon = '';

    if(!empty($arrBin)){
        // set value bin type element
        foreach($arrBin as $bin){
            $bin_id =  $bin["term_id"];
            $garbage_center = check_garbage_platform($bin_id);
            
            if(!$garbage_center){     
                $binNormal = 1;
            }
        }

        if($binNormal > 0){
            foreach($arrBin as $bin){
                $bin_id =  $bin["term_id"];
                $garbage_center = check_garbage_platform($bin_id);
                if(!$garbage_center){
                    $bin_name = $bin["name"];
                    $bin_garbage = false;
                }
            }
        }else{
            foreach($arrBin as $bin){
                $bin_id =  $bin["term_id"];
                $garbage_center = check_garbage_platform($bin_id);
                if($garbage_center){
                    $bin_name = $bin["name"];
                    $bin_garbage = true;
                }
            }
        }
            
        // get icon bin type
        $icon_id = get_term_meta($bin_id, 'icon', true);
        if(!empty($icon_id)){
            $image = wp_get_attachment_image_src( $icon_id, 'thumbnail');
            $image_url = $image[0];
        }else{
            $image_url = '';
        }

        $public_name = get_term_meta($bin_id, 'public_name', true);
        if(!empty($public_name)){
            $bin_name = $public_name;
        }

        // create array bin type element
        $container_type = array(
            'id' => $bin_id,
            'title' => $bin_name,
            'icon' => $image_url,
            'garbage-center' => $bin_garbage
        );
        

    }else{
        $container_type = null;
    }
            
    return $container_type;
}

/**
 * Function for format the garbage type element
 */
function garbage_type_str($garbage_type_id){
    $array_garbage_type = array();
    
    $garbage_type = get_post($garbage_type_id);

     // create array bin type element
     $array_garbage_type = array(
        'id' => $garbage_type->ID,
        'title' => $garbage_type->post_title
    );
    
    return $array_garbage_type;
}

/**
 * Function for check if bin_type is garbage center
 */
function check_garbage_platform($bin_id){
    $result = false;

    //get term checkbox garbage_center
    $garbage_center = get_term_meta($bin_id, 'garbage_center', true);
    if($garbage_center == true){
        $result = true;
    }
    return $result;
}


/**
 * Set header element
 */
function easy_rest_cors() {
	remove_filter( 'rest_pre_serve_request', 'rest_send_cors_headers' );
	add_filter( 'rest_pre_serve_request', function( $value ) {
		header( 'Access-Control-Allow-Origin: *' );
		header( 'Access-Control-Allow-Methods: *' );
		header( 'Access-Control-Allow-Headers: Authorization, Content-Type, zone-id' );
		header( 'Access-Control-Allow-Credentials: true' );
		header( 'Access-Control-Expose-Headers: Link', false );
		return $value;
	} );
}
add_action( 'rest_api_init', 'easy_rest_cors', 15 );

