<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.dueper.net
 * @since             1.0.0
 * @package           Easyeco_Calendar
 *
 * @wordpress-plugin
 * Plugin Name:       Easyeco_Calendar Must Have
 * Plugin URI:        https://www.dueper.net
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Dueper Design snc
 * Author URI:        https://www.dueper.net
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EASYECO_MU_CALENDAR_VERSION', '1.0.0' );

if (!defined('ABSPATH')) {
	die();
}

if (!class_exists('Easyeco_New_Calendar')) {

	class Easyeco_New_Calendar
	{

			public function __construct()
			{
				$this->constants();
				$this->includes();

				//cpt
				$bin = new Bin();
				$garbageType = new Garbage_Type();

				//taxonomies
				$binType = new Bin_Type();
			}

			public function constants()
			{
					if (!defined('EASYECONEW_CALENDAR_DIR')) {
							define('EASYECONEW_CALENDAR_DIR', plugin_dir_path(__FILE__));
					}

					if (!defined('EASYECONEW_CALENDAR_DIR_URL')) {
							define('EASYECONEW_CALENDAR_DIR_URL', plugin_dir_url(__FILE__));
					}
			}

			public function includes()
			{
					require_once EASYECONEW_CALENDAR_DIR . 'includes/cpt/class-garbage-type.php';
					require_once EASYECONEW_CALENDAR_DIR . 'includes/cpt/class-bin.php';

					require_once EASYECONEW_CALENDAR_DIR . 'includes/taxonomies/class-bin-type.php';

					require_once EASYECONEW_CALENDAR_DIR . 'includes/ew-events-plugin.php';
					require_once EASYECONEW_CALENDAR_DIR . 'includes/ew-event-api.php';
					require_once EASYECONEW_CALENDAR_DIR . 'includes/ew-push-notification.php';
			}

	}
	$easyeco_calendar = new Easyeco_New_Calendar();
}