<?php
/*
Plugin Name: Event API plugin
Plugin URI: http://emberware.it/
Description: Event API plugin
Author: Emberware
Version: 1.0
Author URI: http://emberware.it/
*/
if (!defined('ABSPATH')) {
    exit;
}

define('EW_PUSH_SERVER', env('EW_PUSH_SERVER'));
define('EW_PUSH_TOKEN', env('EW_PUSH_TOKEN'));
define('EW_PUSH_TIME', env('EW_PUSH_TIME') ?: '18:00:00');

define('WONDER_PUSH_SERVER', env('WONDER_PUSH_SERVER'));
define('WONDER_PUSH_TOKEN', env('WONDER_PUSH_TOKEN'));
define('WONDER_PUSH_UPDATES_CAMPAIGN', env('WONDER_PUSH_UPDATES_CAMPAIGN'));
define('WONDER_PUSH_CALENDAR_CAMPAIGN', env('WONDER_PUSH_CALENDAR_CAMPAIGN'));

if (!class_exists('EW_PUSH_NOTIFICATION')) {
    /**
     * Gestione notifiche push
     */
    class EW_PUSH_NOTIFICATION
    {

        public static function init()
        {
            if (!wp_next_scheduled('ew_push_garbage')) {
                wp_schedule_event(strtotime(EW_PUSH_TIME), 'daily', 'ew_push_garbage');
            }
            // //wp_schedule_event( strtotime('15:19:00'), 'daily', 'ew_push_garbage' );

        }
    }
}
add_action('plugins_loaded', array('EW_PUSH_NOTIFICATION', 'init'));

/**
 * Function for push notification message on insert new news
 */
function on_news_saved($post_id)
{

    $slug = 'post';
    $post_type = get_post_type($post_id);
    $type = 'updates';
    $arrayZone = array();

    $post = get_post($post_id);
    if ($post_type != $slug) {
        return;
    } else {
        $send_notification = get_post_meta($post_id, 'send_notification', true);

        if (isset($send_notification) && $send_notification) {
            if ($post->post_name != "") {

                $zones = get_the_terms($post_id, 'municipality');

                if ($zones) {
                    foreach ($zones as $zone) {
                        $zone_id =  $zone->term_id;
                        array_push($arrayZone, $zone_id . "-" . $type);
                    }
                    $message =  $post->post_title;

                    //$result = send_notification_garbage_collections($message, $arrayZone, $type);

                    $result = wp_schedule_single_event(time() + 3600, 'ew_push_news', array($message, $arrayZone));

                    if ($result) {
                        update_field('send_notification', '0', $post_id);
                    }
                }
            }
        }
    }
    return $result;
}

/**
 * Function for check the post meta send_notification
 */
add_action('added_post_meta', 'check_post_meta', 10, 4);
add_action('updated_post_meta', 'check_post_meta', 10, 4);
function check_post_meta($meta_id, $post_id, $meta_key, $meta_value)
{
    if ($meta_key == 'send_notification' && $meta_value == '1') {
        on_news_saved($post_id);
    }
}

/**
 * Function for sending push notifications for the next day's garbage collections
 */
function alert_garbage_collections()
{

    //set start and end date tomorrow  
    $start_date = date('Y-m-d', strtotime("+1 day"));
    $end_date = date('Y-m-d', strtotime("+2 day"));

    // //query for list of tribe events 
    $event_args = array(
        'post_type' => 'tribe_events',
        'start_date' => $start_date,
        'end_date' => $end_date,
        'posts_per_page' => -1,
    );

    $tribe_events = tribe_get_events($event_args);

    //format list of events
    if (!empty($tribe_events)) {
        $list_events = garbage_collections_str($tribe_events);
    }

    return new WP_REST_Response($list_events, 200);
}
add_action('ew_push_garbage', 'alert_garbage_collections');

/**
 * Function for format the garbage collection message
 */
function garbage_collections_str($tribe_events)
{
    $i = 0;
    $zone_id = 0;
    $zone_name = "";
    $message = "";
    $type = "calendar";
    $arrZone = array();

    if (!empty($tribe_events)) {
        foreach ($tribe_events as $event_tribe) {

            //  print_r($event_tribe);
            $event_id = $event_tribe->ID;

            // load bin type and format array bin type
            $bins_type = get_the_terms($event_id, 'bin_type');
            foreach ($bins_type as $bin_type) {
                $container_type = get_term_meta($bin_type->term_id, 'public_name', true);
                if (empty($container_type)) {
                    $container_type = $bin_type->name;
                }
            }

            // load zone
            $zones = get_the_terms($event_id, 'municipality');
            foreach ($zones as $zone) {
                if ($zone_id != $zone->term_id) {
                    //print_r($message);
                    if ($i == 0) {
                        // è il primo ciclo
                        $municipality = get_term($zone->parent, 'municipality');
                        $municipality_zone = $municipality->name;

                        $zone_id =  $zone->term_id;
                        //array_push($arrZone, $zone_id);
                        $zone_name =  $zone->name;
                        $message = "Domani verrà ritirato: " . $container_type;
                    } else {
                        $zones_to_send = [$zone_id . "-" . $type];
                        $result = send_notification_garbage_collections($message, $zones_to_send);

                        $municipality = get_term($zone->parent, 'municipality');
                        $municipality_zone = $municipality->name;

                        $zone_id =  $zone->term_id;
                        //array_push($arrZone, $zone_id);
                        $zone_name =  $zone->name;
                        $message = "Domani verrà ritirato: " . $container_type;
                    }
                } else {
                    $message .= ", " . $container_type;
                }
                $i++;
            }
        }
    }
    $zones_to_send = [$zone_id . "-" . $type];
    $result = send_notification_garbage_collections($message, $zones_to_send);
}

/**
 * Function for generate push notification message 
 */
add_action('ew_push_news', 'send_notification_garbage_collections', 10, 3);
function send_notification_garbage_collections($message, $zones)
{

    $aerogear = send_notification_aerogear($message, $zones);
    $wonderpush = send_notification_wonderpush($message, $zones);
}

function send_notification_aerogear($message, $zones)
{
    $block_ag = !EW_PUSH_SERVER;
    if ($block_ag) {
        return false;
    }

    $messArray = [
        "message" => [
            "alert" => $message,
            "sound" => "default",
            "user-data" => [
                "key" => "value",
            ],
        ],
        "criteria" => [
            "categories" => $zones,
        ],
    ];

    $message = json_encode($messArray);

    $urlPost = EW_PUSH_SERVER . "/rest/sender";

    $headers = [
        "Authorization: Basic " . EW_PUSH_TOKEN,
        "Content-Type: application/json"
    ];

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, $urlPost);
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $message);

    $result = curl_exec($curl);
    curl_close($curl);

    if ($result) {
        return true;
    } else {
        return false;
    }
}

function send_notification_wonderpush($message, $zones)
{

    $block_wonderpush = !WONDER_PUSH_SERVER;
    if ($block_wonderpush) {
        return false;
    }

    if (count($zones)) {
        if (str_contains($zones[0], "updates")) {
            $campaignId = WONDER_PUSH_UPDATES_CAMPAIGN;
        } elseif (str_contains($zones[0], "calendar")) {
            $campaignId = WONDER_PUSH_CALENDAR_CAMPAIGN;
        }
    }

    $messArray = [
        "notification" => [
            "alert" => [
                "text" => $message,
            ],
            "push" => [
                "payload" => [
                    "tag" => $zones,
                ],
            ],
        ],
        "campaignId" => $campaignId,
        "targetTags" => $zones,
    ];

    $message = json_encode($messArray);

    $urlPost = WONDER_PUSH_SERVER . "/v1/deliveries?accessToken=" . WONDER_PUSH_TOKEN;

    $headers = [
        "Content-Type: application/json"
    ];

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, $urlPost);
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $message);

    $result = curl_exec($curl);
    curl_close($curl);

    if ($result) {
        return true;
    } else {
        return false;
    }
}
