<?php

add_action('init', function() {
  if (!function_exists('get_field')) return false;

  global $thor_custom_snippets;

  $thor_custom_snippets = get_field('code_snippets', 'options');
});

add_action('wp_head', function() {
  global $thor_custom_snippets;

  if($thor_custom_snippets) {
    foreach($thor_custom_snippets as $snippet) {
      if($snippet['script_position'] === 'head') {
        print $snippet['snippet'];
      }
    }
  }

});

add_action('wp_footer', function() {
  global $thor_custom_snippets;

  if($thor_custom_snippets) {
    foreach($thor_custom_snippets as $snippet) {
      if($snippet['script_position'] === 'footer') {
        print $snippet['snippet'];
      }
    }
  }
});

add_action('in_body', function() {
  global $thor_custom_snippets;

  if($thor_custom_snippets) {
    foreach($thor_custom_snippets as $snippet) {
      if($snippet['script_position'] === 'body') {
        print $snippet['snippet'];
      }
    }
  }
});
