<?php

class EE_REST_Config_Controller
{
    protected $namespace;
    protected $rest_base;

    public function __construct()
    {
        $this->namespace = 'ee/v1';
        $this->rest_base = 'config';
    }

    public function register_routes()
    {

        register_rest_route(
            $this->namespace,
            '/' . $this->rest_base,
            array(
                array(
                    'methods' => WP_REST_Server::READABLE,
                    'callback' => array($this, 'get_items'),
                ),
            )
        );
    }

    public function get_items($request)
    {
        $coord_choose = (bool)get_option('options_coord_choose');
        $privacy_page = get_option('options_privacy_page');
        $obj = [
            'coord_choose' => $coord_choose,
            'privacy_page' => $privacy_page,
        ];
        return $obj;
    }
}
