<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.dueper.net
 * @since             1.0.0
 * @package           Easyeco_New_Mu
 *
 * @wordpress-plugin
 * Plugin Name:       Easyeco-new Must Have
 * Plugin URI:        https://www.dueper.net
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            Dueper Design snc
 * Author URI:        https://www.dueper.net
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EASYECO_NEW_MU_VERSION', '1.0.0' );

if (!defined('ABSPATH')) {
	die();
}

if (!class_exists('Easyeco_New')) {

	class Easyeco_New
	{
			public function __construct()
			{
					$this->constants();
					$this->includes();
					
					$this->new_roles();
					$report_roles = ['administrator', 'editor', 'webmaster'];
					foreach($report_roles as $report_role){
						$this->new_capabilities_by_role($report_role);
					}
					
					//cpt
					$garbage = new Garbage();
					$garbageCenter = new Garbage_Center();
					$report = new Report();
					$street = new Street();

					//taxonomies
					$municipality = new Municipality();
				
					//rest controller
					add_action( 'rest_api_init', array($this, 'Easyeco_New_create_initial_rest_routes'), 99 );
					add_action('admin_init', array($this, 'remove_dashboard_meta'));
					add_action('wp_dashboard_setup', array($this, 'easyeco_new_dashboard_widget'));
			}


			public function remove_dashboard_meta() {
				remove_meta_box( 'dashboard_primary', 'dashboard', 'side' );
				remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
				remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'side' );

				remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
				remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
				remove_meta_box( 'dashboard_secondary', 'dashboard', 'normal' );
				remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
				remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
				remove_meta_box( 'dashboard_activity', 'dashboard', 'normal');
				
				remove_meta_box( 'tribe_dashboard_widget', 'dashboard', 'side' );
			}

			public function easyeco_new_dashboard_widget() {
				wp_add_dashboard_widget('easyeco_new_zones_widget', 'Zone e Comuni', array($this, 'easyeco_new_zones_widget'));
			}
			 
			public function easyeco_new_zones_widget() {
				$args = [
					'taxonomy' => 'municipality',
					'hide_empty' => false,
					'fields' => 'count',
					'parent' => 0,
				];
				$cities_count = get_terms($args);
				echo '<p>'.$cities_count.' Comuni</p>';

				$args = [
					'taxonomy' => 'municipality',
					'hide_empty' => false,
					'fields' => 'count',
					'childless' => true,
				];
				$zones_count = get_terms($args);
				echo '<p>'.$zones_count.' Zone</p>';
			}

			public function new_roles(){
				add_role('operator', __('Ruolo Segnalazioni', 'thor'), array(
						'read' => true,
						'edit_report' => true,
						'read_report' => true,
						'delete_report' => true,
						'edit_reports' => true,
						'edit_others_reports' => true,
						'publish_reports' => true,
						'read_private_reports' => true,
				));
			}

			public function new_capabilities_by_role($role_name){
				$role = get_role($role_name);
		
				if($role && !is_wp_error($role)){
					$role->add_cap('edit_report', true);
					$role->add_cap('read_report', true);
					$role->add_cap('delete_report', true);
					$role->add_cap('edit_reports', true);
					$role->add_cap('edit_others_reports', true);
					$role->add_cap('publish_reports', true);
					$role->add_cap('read_private_reports', true);
				}
			}

			public function Easyeco_New_create_initial_rest_routes(){
					$garbage_centers_controller = new EE_REST_Garbage_Centers_Controller;
					$garbage_centers_controller->register_routes();
					$garbages_controller = new EE_REST_Garbages_Controller;
					$garbages_controller->register_routes();
					$reports_controller = new EE_REST_Reports_Controller;
					$reports_controller->register_routes();
					$custom_pages_controller = new EE_REST_Pages_Controller;
					$custom_pages_controller->register_routes();
					$custom_posts_controller = new EE_REST_Posts_Controller;
					$custom_posts_controller->register_routes();
					$municipalities_controller = new EE_REST_Municipalities_Controller;
					$municipalities_controller->register_routes();
					$config_controller = new EE_REST_Config_Controller;
					$config_controller->register_routes();
			}

			public function constants()
			{
					if (!defined('EASYECONEW_DIR')) {
							define('EASYECONEW_DIR', plugin_dir_path(__FILE__));
					}

					if (!defined('EASYECONEW_DIR_URL')) {
							define('EASYECONEW_DIR_URL', plugin_dir_url(__FILE__));
					}
			}

			public function includes()
			{
					require_once EASYECONEW_DIR . 'includes/advanced-custom-fields.php';
					require_once EASYECONEW_DIR . 'includes/custom-snippets.php';
					require_once EASYECONEW_DIR . 'includes/cpt/class-garbage.php';
					require_once EASYECONEW_DIR . 'includes/cpt/class-garbage-center.php';
					require_once EASYECONEW_DIR . 'includes/cpt/class-report.php';
					require_once EASYECONEW_DIR . 'includes/cpt/class-street.php';

					require_once EASYECONEW_DIR . 'includes/taxonomies/class-municipality.php';

					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-garbage-centers-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-garbages-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-reports-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-pages-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-posts-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-municipalities-controller.php';
					require_once EASYECONEW_DIR . 'includes/RestApiControllers/class-ee-rest-config-controller.php';
			}
	}
	$easyeco_new = new Easyeco_New();
}