<?php
class Report
{
    public function __construct()
    {
        add_action('init', array($this, 'easyeco_new_create_cpt_report'), 0);
        add_action('add_meta_boxes', array($this, 'easyeco_new_add_maps_link_meta_box'));
        add_action('updated_post_meta', array($this, 'easyeco_new_report_on_save'), 20, 4);
        add_filter('acf/fields/taxonomy/query/name=comuni_associati', array($this, 'my_acf_fields_relationship_query'), 10, 3);
        add_action('pre_get_posts', array($this, 'filter_report_for_user_by_zone'), 10);
        add_filter('wp_count_posts', array($this, 'set_report_count_post'), 10, 3);
        add_action('rest_after_insert_report', array($this, 'send_mail_after_report_creation'), 10, 3);
    }

    public function easyeco_new_create_cpt_report()
    {
        $labels = array(
            'name' => _x('Segnalazioni', 'Post Type General Name', 'easyeco_new'),
            'singular_name' => _x('Segnalazione', 'Post Type Singular Name', 'easyeco_new'),
            'menu_name' => __('Segnalazioni', 'easyeco_new'),
            'name_admin_bar' => __('Segnalazione', 'easyeco_new'),
            'archives' => __('Item Archives', 'easyeco_new'),
            'attributes' => __('Item Attributes', 'easyeco_new'),
            'parent_item_colon' => __('Parent Item:', 'easyeco_new'),
            'all_items' => __('All Items', 'easyeco_new'),
            'add_new_item' => __('Add New Item', 'easyeco_new'),
            'add_new' => __('Add New', 'easyeco_new'),
            'new_item' => __('New Item', 'easyeco_new'),
            'edit_item' => __('Edit Item', 'easyeco_new'),
            'update_item' => __('Update Item', 'easyeco_new'),
            'view_item' => __('View Item', 'easyeco_new'),
            'view_items' => __('View Items', 'easyeco_new'),
            'search_items' => __('Search Item', 'easyeco_new'),
            'not_found' => __('Not found', 'easyeco_new'),
            'not_found_in_trash' => __('Not found in Trash', 'easyeco_new'),
            'featured_image' => __('Featured Image', 'easyeco_new'),
            'set_featured_image' => __('Set featured image', 'easyeco_new'),
            'remove_featured_image' => __('Remove featured image', 'easyeco_new'),
            'use_featured_image' => __('Use as featured image', 'easyeco_new'),
            'insert_into_item' => __('Insert into item', 'easyeco_new'),
            'uploaded_to_this_item' => __('Uploaded to this item', 'easyeco_new'),
            'items_list' => __('Items list', 'easyeco_new'),
            'items_list_navigation' => __('Items list navigation', 'easyeco_new'),
            'filter_items_list' => __('Filter items list', 'easyeco_new'),
        );
        $capabilities = array(
            'edit_post'             => 'edit_report',
            'read_post'             => 'read_report',
            'delete_post'           => 'delete_report',
            'edit_posts'            => 'edit_reports',
            'edit_others_posts'     => 'edit_others_reports',
            'publish_posts'         => 'publish_reports',
            'read_private_posts'    => 'read_private_reports',
        );
        $args = array(
            'label' => __('Segnalazione', 'easyeco_new'),
            'description' => __('Post Type Description', 'easyeco_new'),
            'labels' => $labels,
            'supports' => array('title', 'editor'),
            'taxonomies' => array('municipality'),
            'hierarchical' => false,
            'public' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'menu_position' => 6,
            'show_in_admin_bar' => true,
            'show_in_nav_menus' => true,
            'can_export' => true,
            'has_archive' => true,
            'exclude_from_search' => false,
            'publicly_queryable' => true,
            'capability_type' => 'post',
            'show_in_rest' => true,
            'rest_base' => 'reports',
            'capabilities' => $capabilities,
        );
        register_post_type('report', $args);
    }

    private function build_email_template($zone, $post_id)
    {
        $mailTemplatePath = EASYECONEW_DIR . 'includes' . DIRECTORY_SEPARATOR . 'template' . DIRECTORY_SEPARATOR . 'email_template.html';
        $imagesUrl = EASYECONEW_DIR_URL .'includes/template/images/';
        
        if(function_exists('get_field')){
            $application_logo = get_field('application_logo', 'option');
            $customer_logo = get_field('customer_logo', 'option');
            $customer_link = get_field('customer_link', 'option');
        } else {
            $application_logo = wp_get_attachment_url((int)get_option('options_application_logo'));
            $customer_logo = wp_get_attachment_url((int)get_option('options_customer_logo'));
            $customer_link = get_option('options_customer_link');
        }

        $municipality = get_term($zone->parent, 'municipality');
        $address = get_post_meta($post_id, 'address', true);
        $firstname = get_post_meta($post_id, 'firstname', true);
        $lastname = get_post_meta($post_id, 'lastname', true);
        $cf = get_post_meta($post_id, 'cf', true);
        $email = get_post_meta($post_id, 'email', true);
        $phone = get_post_meta($post_id, 'phone', true);
        $type = get_post_meta($post_id, 'type', true);
        if(function_exists('get_field_object')){
            $field = get_field_object('field_5e8d9fdccaed5');
            $type = $field['choices'][ $type ];
        }
        $note = get_post_meta($post_id, 'note', true);

        $link = WP_SITEURL.'/wp-admin/post.php?post='.$post_id.'&action=edit';

        $message = file_get_contents($mailTemplatePath);
        $message = str_replace('{{zone}}', $zone->name, $message);
        $message = str_replace('{{municipality}}', $municipality->name, $message);
        $message = str_replace('{{address}}', $address, $message);
        $message = str_replace('{{firstname}}', $firstname, $message);
        $message = str_replace('{{lastname}}', $lastname, $message);
        $message = str_replace('{{cf}}', $cf, $message);
        $message = str_replace('{{email}}', $email, $message);
        $message = str_replace('{{phone}}', $phone, $message);
        $message = str_replace('{{type}}', $type, $message);
        $message = str_replace('{{note}}', $note, $message);
        $message = str_replace('{{link}}', $link, $message);
        $message = str_replace('{{customer_logo}}', $customer_logo, $message);
        $message = str_replace('{{application_logo}}', $application_logo, $message);
        $message = str_replace('{{customer_link}}', $customer_link, $message);
        error_log($message);
        return $message;
    }

    public function send_mail_after_report_creation($post, $request, $create){
        if($create){
            $zone_id = $request->get_header('zone-id');
            $zone = get_term($zone_id, 'municipality');
            if (!is_wp_error($zone) && !is_null($zone) && $zone->parent){
                $args = [
                    'meta_key' => 'comuni_associati',
                    'meta_value' => '"' . $zone->parent . '"',
                    'meta_compare' => 'LIKE',
                    'fields' => ['user_email'],
                ];
                $user_query = new WP_User_Query( $args );
                if (!empty($user_query->get_results())) {
                    $emails = [];
                    foreach ($user_query->get_results() as $user) {
                        array_push($emails, $user->user_email);
                    }
                    $message = $this->build_email_template($zone, $post->ID);
                    $images = [];
                    $imageIds = get_post_meta($post->ID, 'images', true);
                    foreach($imageIds as $imageId){
                        $image = get_attached_file($imageId);
                        array_push($images, $image);
                    }

                    $result = wp_mail($emails, "Nuova Segnalazione", $message, array('Content-Type: text/html; charset=UTF-8;'), $images);
                }
            }
        }
    }

    public function set_report_count_post($counts, $type, $perm){
        $user = wp_get_current_user();
        if (in_array('operator', (array)$user->roles) && $type = 'report'){
            //a query just to trigger set post meta and get the correct value for count
            $query = [
                'post_type' => 'report',
                'posts_per_page' => -1,
                'post_status' => 'any',
            ];
            $result = new WP_Query($query);
        //new counts based on filtered reports
            $new_counts = [];
            if ( $result->have_posts() ) {
                foreach ($result->get_posts() as $post) {
                    $status = $post->post_status;
                    if(isset($new_counts[$status])){
                        $new_counts[$status] += 1;
                    } else {
                        $new_counts[$status] = 1;
                    }
                }
                foreach ($new_counts as $status => $value) {
                    $counts->$status = (string)$value;
                }
                return $counts;
            } else {
                return $new_counts;
            }
        }
        return $counts;
    }

    public function filter_report_for_user_by_zone($query){
        $user = wp_get_current_user();
        if (in_array('operator', (array)$user->roles) && $query->get('post_type') == "report") {
            $comuni_associati = get_user_meta(get_current_user_id(), 'comuni_associati', true);
            $query->set('tax_query', [
                [
                    'taxonomy' => 'municipality',
                    'field'    => 'id',
                    'terms'    => $comuni_associati,
                ],
            ]);
        }
    }

    public function my_acf_fields_relationship_query($args, $field, $post_id){
        $args['parent'] = 0;
        $args['orderby'] = 'name';
        $args['order'] = 'ASC';

        return $args;
    }

    public function easyeco_new_add_maps_link_meta_box()
    {
        add_meta_box("easyeco-new-maps-link-meta-box", "Maps Link", array($this, "easyeco_new_maps_link_meta_box_markup"), "report");
        add_meta_box("easyeco-new-status-change-time-meta-box", "Tempo cambi di stato", array($this, "easyeco_new_status_change_time_meta_box_markup"), "report");
    }

    public function easyeco_new_status_change_time_meta_box_markup($post)
    {
        $in_charge_time = get_post_meta($post->ID, 'in_charge_time', true);
        $close_time = get_post_meta($post->ID, 'close_time', true);
        $in_charge_time = $in_charge_time ? $in_charge_time : "non disponibile";
        $close_time = $close_time ? $close_time : "non disponibile";

        echo '
        <div>
            <p>Tempo presa in carico</p>
            <p>Tempo trascorso dalla segnalazione alla presa in carico</p>
            <p>'.$in_charge_time.'</p>
        </div>
        <div>
            <p>Tempo chiusura</p>
            <p>Tempo trascorso dalla presa in carico alla chiusura</p>
            <p>'.$close_time.'</p>
        </div>
        ';
    }

    public function easyeco_new_maps_link_meta_box_markup($post)
    {
        $lat = get_post_meta($post->ID, 'latitude', true);
        $lng = get_post_meta($post->ID, 'longitude', true);
        if($lat && $lng){
            $link="https://maps.google.com/?ll=".$lat.",".$lng;
        } else {
            $address= get_post_meta($post->ID, 'address', true);
            $link = "https://www.google.com/maps/search/?api=1&query=".rawurlencode($address);
        }
        echo '
        <div>
            <p>Vedi la posizione della segnalazione su google maps</p>
            <p><a href="'.$link.'" target="_blank">'.$link.'</a></p>
        </div>
        ';
    }

    public function date_difference($timestamp1, $timestamp2)
    {
        $datetime1 =  new DateTime("@$timestamp1");
        $datetime2 = new DateTime("@$timestamp2");
    
        $interval = date_diff($datetime1, $datetime2);
    
        return $interval->format('%d Giorni %h Ore %i Minuti');
    }

    public function easyeco_new_report_on_save($meta_id, $object_id, $meta_key, $_meta_value)
    {
        if($meta_key == 'status'){
            $current_timestamp = time();
            switch ($_meta_value) {
                case 'taken':
                    update_post_meta($object_id, 'taken_timestamp', $current_timestamp);

                    $not_taken_timestamp = get_post_meta($object_id, 'not_taken_timestamp', true);
                    $in_charge_time = $this->date_difference($current_timestamp, $not_taken_timestamp);
                    update_post_meta($object_id, 'in_charge_time', $in_charge_time);

                    break;
                case 'canceled':
                    update_post_meta($object_id, 'canceled_timestamp', $current_timestamp);

                    $taken_timestamp = get_post_meta($object_id, 'taken_timestamp', true);
                    $close_time = $this->date_difference($current_timestamp, $taken_timestamp);
                    update_post_meta($object_id, 'close_time', $close_time);

                    break;
                case 'closed':
                    update_post_meta($object_id, 'closed_timestamp', $current_timestamp);

                    $taken_timestamp = get_post_meta($object_id, 'taken_timestamp', true);
                    $close_time = $this->date_difference($current_timestamp, $taken_timestamp);
                    update_post_meta($object_id, 'close_time', $close_time);

                    break;
            }
        }
    }
}
