<?php

add_action('plugins_loaded', 'smarteco_on_activation');

function smarteco_on_activation()
{
  if (!wp_next_scheduled('privacy_remove_old_report')) {
    wp_schedule_event(time(), 'daily', 'privacy_remove_old_report');
  }
}

function privacy_remove_old_report()
{
  $posts = get_posts(array(
    'posts_per_page' => 1000,
    'post_type'   => 'report',
    'post_status' => 'publish',
    'date_query'  => array(
      array(
        'before' => '3 year ago',
      ),
    ),
  ));

  foreach ($posts as $post) {
    wp_delete_post($post->ID, false);
  }
}
add_action('privacy_remove_old_report', 'privacy_remove_old_report');

register_deactivation_hook(__FILE__, 'smarteco_on_deactivation');
add_action('smarteco_on_deactivation', 'smarteco_on_deactivation');

function smarteco_on_deactivation()
{
  wp_unschedule_event('privacy_remove_old_report');
}
