<?php

//Add wp_pagenavi bootstrap compatibility
if ( !function_exists('wp_pagenavi_bootstrap')) {
  add_filter( 'wp_pagenavi', 'wp_pagenavi_bootstrap', 10, 2 );
  function wp_pagenavi_bootstrap($html) {
    $out = '';
    //wrap a's and span's in li's
    $out = str_replace("<div","",$html);
    $out = str_replace("class='wp-pagenavi'>","",$out);
    $out = str_replace("<a","<li><a",$out);
    $out = str_replace("</a>","</a></li>",$out);
    $out = str_replace("<span","<li><span",$out);
    $out = str_replace("</span>","</span></li>",$out);
    $out = str_replace("</div>","",$out);
      $out = str_replace("<li><span class='current'>","<li class='active'><span>",$out);

    return '<div class="text-center"><ul class="pagination pagination-centered">'.$out.'</ul></div>';
  }
}

// Remove additional profile info
if (!function_exists('dueper_remove_profile_fields')) {
  add_filter('user_contactmethods','dueper_remove_profile_fields', 10, 2);
  function dueper_remove_profile_fields( $contactmethods ) {
    unset($contactmethods['aim']);
    unset($contactmethods['jabber']);
    unset($contactmethods['yim']);
    return $contactmethods;
  }
}

// Add featured image in RSS
if ( !function_exists('dueper_rss_post_thumbnail')) {
  add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail', 10, 2);
  add_filter('the_content_feed', 'dueper_rss_post_thumbnail', 10, 2);
  function dueper_rss_post_thumbnail($content) {
    global $post;
    if(has_post_thumbnail($post->ID)) :
      $content = '<p>' . get_the_post_thumbnail($post->ID) .
      '</p>' . get_the_content();
    endif;
    return $content;
  }
}

// Revising Default Excerpt
if ( !function_exists('bootstrapwp_excerpt')) {
  add_filter('excerpt_more', 'bootstrapwp_excerpt', 10, 2);
  function bootstrapwp_excerpt($more) {
    global $post;
    return '...';
  }
}

//Revising Default Excerpt
if ( !function_exists('dueper_excerpt_length')) {
  add_filter( 'excerpt_length', 'dueper_excerpt_length', 10, 2 );
  function dueper_excerpt_length( $length ) {
    return 20;
  }
}

// filter the Gravity Forms button type
add_filter( 'gform_submit_button', 'form_submit_button', 10, 2 );
function form_submit_button( $button, $form ) {
  return "<button class='btn' id='gform_submit_button_{$form['id']}'>".$form['button']['text']."</button>";
}

//Funzione per convertire numeri in romani
function romanic_number($integer, $upcase = true) {
  $table = array('M'=>1000, 'CM'=>900, 'D'=>500, 'CD'=>400, 'C'=>100, 'XC'=>90, 'L'=>50, 'XL'=>40, 'X'=>10, 'IX'=>9, 'V'=>5, 'IV'=>4, 'I'=>1);
  $return = '';
  while($integer > 0) {
    foreach($table as $rom=>$arb) {
      if($integer >= $arb) {
        $integer -= $arb;
        $return .= $rom;
        break;
      }
    }
  }
  return $return;
}

// work archive post limit
function update_archive_work_query( $query ) {
if ( $query->is_post_type_archive('work') && $query->is_main_query() && !is_admin() ) {
    $query->set( 'posts_per_page', 50 );
  }
}
add_action( 'pre_get_posts', 'update_archive_work_query' );
