<?php
if ( ! function_exists('partner_CPT_creator') ) {

  // Register Custom Post Type
  function partner_CPT_creator() {

  	$labels = array(
  		'name'                  => _x( 'Partners', 'Post Type General Name', 'dueper' ),
  		'singular_name'         => _x( 'Partner', 'Post Type Singular Name', 'dueper' ),
  		'menu_name'             => __( 'Partners', 'dueper' ),
  		'name_admin_bar'        => __( 'Partners', 'dueper' ),
  		'archives'              => __( 'Partners Archives', 'dueper' ),
  		'parent_item_colon'     => __( 'Parent Partner:', 'dueper' ),
  		'all_items'             => __( 'All Partners', 'dueper' ),
  		'add_new_item'          => __( 'Add New Partner', 'dueper' ),
  		'add_new'               => __( 'Add New', 'dueper' ),
  		'new_item'              => __( 'New Partner', 'dueper' ),
  		'edit_item'             => __( 'Edit Partner', 'dueper' ),
  		'update_item'           => __( 'Update Partner', 'dueper' ),
  		'view_item'             => __( 'View Item', 'dueper' ),
  		'search_items'          => __( 'Search Item', 'dueper' ),
  		'not_found'             => __( 'Not found', 'dueper' ),
  		'not_found_in_trash'    => __( 'Not found in Trash', 'dueper' ),
  		'featured_image'        => __( 'Featured Image', 'dueper' ),
  		'set_featured_image'    => __( 'Set featured image', 'dueper' ),
  		'remove_featured_image' => __( 'Remove featured image', 'dueper' ),
  		'use_featured_image'    => __( 'Use as featured image', 'dueper' ),
  		'insert_into_item'      => __( 'Insert into Partner', 'dueper' ),
  		'uploaded_to_this_item' => __( 'Uploaded to this Partner', 'dueper' ),
  		'items_list'            => __( 'Partners list', 'dueper' ),
  		'items_list_navigation' => __( 'Partners list navigation', 'dueper' ),
  		'filter_items_list'     => __( 'Filter Partners list', 'dueper' ),
  	);
  	$args = array(
  		'label'                 => __( 'Partner', 'dueper' ),
  		'labels'                => $labels,
  		'supports'              => array( 'title', 'editor', 'author', 'revisions', ),
  		'taxonomies'            => array(),
  		'hierarchical'          => false,
  		'public'                => true,
  		'show_ui'               => true,
  		'show_in_menu'          => true,
  		'menu_position'         => 5,
  		'menu_icon'             => 'dashicons-awards',
  		'show_in_admin_bar'     => true,
  		'show_in_nav_menus'     => false,
  		'can_export'            => true,
  		'has_archive'           => true,
  		'exclude_from_search'   => false,
  		'publicly_queryable'    => true,
  		'capability_type'       => 'page',
  	);
  	register_post_type( 'partner', $args );

  }
  add_action( 'init', 'partner_CPT_creator', 0 );

}
