<?php
if ( ! function_exists('work_CPT_creator') ) {

  // Register Custom Post Type
  function work_CPT_creator() {

  	$labels = array(
  		'name'                  => _x( 'Works', 'Post Type General Name', 'dueper' ),
  		'singular_name'         => _x( 'Work', 'Post Type Singular Name', 'dueper' ),
  		'menu_name'             => __( 'Works', 'dueper' ),
  		'name_admin_bar'        => __( 'Works', 'dueper' ),
  		'archives'              => __( 'Works Archives', 'dueper' ),
  		'parent_item_colon'     => __( 'Parent Work:', 'dueper' ),
  		'all_items'             => __( 'All Works', 'dueper' ),
  		'add_new_item'          => __( 'Add New Work', 'dueper' ),
  		'add_new'               => __( 'Add New', 'dueper' ),
  		'new_item'              => __( 'New Work', 'dueper' ),
  		'edit_item'             => __( 'Edit Work', 'dueper' ),
  		'update_item'           => __( 'Update Work', 'dueper' ),
  		'view_item'             => __( 'View Item', 'dueper' ),
  		'search_items'          => __( 'Search Item', 'dueper' ),
  		'not_found'             => __( 'Not found', 'dueper' ),
  		'not_found_in_trash'    => __( 'Not found in Trash', 'dueper' ),
  		'featured_image'        => __( 'Featured Image', 'dueper' ),
  		'set_featured_image'    => __( 'Set featured image', 'dueper' ),
  		'remove_featured_image' => __( 'Remove featured image', 'dueper' ),
  		'use_featured_image'    => __( 'Use as featured image', 'dueper' ),
  		'insert_into_item'      => __( 'Insert into Work', 'dueper' ),
  		'uploaded_to_this_item' => __( 'Uploaded to this Work', 'dueper' ),
  		'items_list'            => __( 'Works list', 'dueper' ),
  		'items_list_navigation' => __( 'Works list navigation', 'dueper' ),
  		'filter_items_list'     => __( 'Filter Works list', 'dueper' ),
  	);
  	$args = array(
  		'label'                 => __( 'Work', 'dueper' ),
  		'labels'                => $labels,
  		'supports'              => array( 'title', 'editor', 'author', 'thumbnail', 'revisions', ),
  		'taxonomies'            => array( 'category' ),
  		'hierarchical'          => false,
  		'public'                => true,
  		'show_ui'               => true,
  		'show_in_menu'          => true,
  		'menu_position'         => 5,
  		'menu_icon'             => 'dashicons-video-alt3',
  		'show_in_admin_bar'     => true,
  		'show_in_nav_menus'     => true,
  		'can_export'            => true,
  		'has_archive'           => true,
  		'exclude_from_search'   => false,
  		'publicly_queryable'    => true,
  		'capability_type'       => 'page',
  	);
  	register_post_type( 'work', $args );

  }
  add_action( 'init', 'work_CPT_creator', 0 );

}
