<?php
$image = get_field('intro_image');
$text = get_field('intro_text');
$video = get_field('intro_video');
?>


<div class="intro-wrapper" <?php if($image) echo 'style=" background-image: url('.$image['sizes']['large-thumb'].');"'; ?>>
  <?php if($text): ?>
    <h2 class="intro-title"><?php echo $text; ?></h2>
  <?php endif; ?>
  <?php if($video): ?>
    <video class="hidden-xs" preload autoplay loop>
      <source src="<?php echo $video; ?>" type="video/mp4">
    </video>
  <?php endif; ?>

  <svg id="mouse" width="203" height="185" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <g fill="none">
      <rect id="mouse-outline" x="60.333" y="3" width="89.333" height="165.333" stroke="#02969C" stroke-width="3" rx="44"/>
      <text id="mouse-text" font-size="18.667" font-weight="500" text-transform="uppercase" letter-spacing="10.667" fill="#fff">
        <tspan x="50%" y="50%" width="100%" text-anchor="middle">
          <?php the_title(); ?>
        </tspan>
      </text>
      <g fill="#02969C" id="mouse-wheel" >
        <circle cx="105.667" cy="32" r="4"/>
      </g>
    </g>
  </svg>

</div><!--intro-wrapper-->
