(function($){
  $(document).ready(init_fullpage);

  window.addEventListener("orientationchange", function() {
    $.fn.fullpage.destroy('all');
    init_fullpage();
  });


  function init_fullpage() {
    $('#home-page').fullpage({
      sectionSelector: '.home-section',
      scrollingSpeed: 1000,
      onLeave: onLeave,
      responsiveWidth: 768,
      continuousVertical: false,
      afterLoad: function() {
        var video = $('#intro video');
        if(video.length){
          $('#intro video')[0].play();
        }
      },
      // responsiveWidth: 768,
      css3: false,
      menu: '#home-menu',
    });

    TweenMax.set( $('.home-section').find('.work-title'), { clearProps: "all" } );
    TweenMax.set( $('.home-section').find('.work-content'), { clearProps: "all" } );
    TweenMax.set( $('.home-section').find('.category'), { clearProps: "all" } );

    /*
    SETUP SECTIONS
    */
    TweenMax.set($('.home-section').find('.work-title') ,{ opacity: 0, left: "25%" });
    TweenMax.set($('.home-section').find('.work-content'), { opacity: 0, bottom: "-=50px", });
    TweenMax.set($('.home-section').find('.category'), { opacity: 0, letterSpacing: '3vw', filter: "blur(15px)"});

    function onLeave(index, nextIndex, direction){
      // init controller
      var old = $('.home-section').eq(index-1);
      var oldTitle = old.find('.work-title');
      var oldCategory = old.find('.category');
      var oldContent = old.find('.work-content');
      var oldImage = old.find('.work-image');
      var oldRight = old.find('.right');
      var oldColor = old.find('.work-teaser').attr('data-color');

      var next = $('.home-section').eq(nextIndex-1);
      var nextTitle = next.find('.work-title');
      var nextCategory = next.find('.category');
      var nextContent = next.find('.work-content');
      var nextImage = next.find('.work-image');
      var nextRight = next.find('.right');
      var nextColor = next.find('.work-teaser').attr('data-color');

      var inTimeline = new TimelineMax();
      var outTimeline = new TimelineMax();

      //Se l'interazione non è fatta con il footer animo le sezioni
      if(!next.is("#credits") && !old.is("#credits")) {
        outTimeline.add([
          TweenMax.to(oldTitle, 1, { opacity: 0, left: "25%" }),
          TweenMax.to(oldContent, 0.5, { opacity: 0, bottom: "-=50px", }),
          TweenMax.to(oldCategory, 1.5, { opacity: 0, letterSpacing: '3vw', filter: "blur(15px)" }),
        ]);

        inTimeline.add([
          TweenMax.to(nextTitle, 1, { opacity: 1, left: "10%", delay: 0.2 }),
          TweenMax.to(nextContent, 0.5, { opacity: 1, bottom: "+=50px", delay: 0.5 }),
          TweenMax.to(nextCategory, 1.5, { opacity: 1, letterSpacing: '1vw', delay: 0.5, filter: "blur(0px)" }),
          // TweenMax.to(nextRight, .7, { top: '0%', ease: Power1.easeInOut }),
          TweenMax.to($('body'), 0.5, { backgroundColor: nextColor }),
        ]);
      }

    }
  }

  /*
  ON HOVER A PROJECT IMAGE
  */
  var playBtn = $('#project-hover');
  //On mouse over and out
  $('.right, .work-teaser-small').on('mousemove', function(e){
    TweenMax.set(playBtn, {top: e.clientY, left: e.clientX, ease: Power0.easeNone });
  });

  //On mouse over and out
  $('.right, .work-teaser-small')
    .mouseover(function() {
      TweenMax.set(playBtn, {rotation: 90, scale: 1.8, opacity: 0 });
      TweenMax.to(playBtn, 0.5, {opacity: 1, display: "block", rotation: 0, scale: 1 });
    })
    .mouseout(function() {
      TweenMax.to(playBtn, 0.2, {opacity: 0, display: "none", rotation: 90, scale: 1.8 });
    });


})(jQuery);
