<?php
$video = get_field('video');
$external_url = get_field('external_url');
$color = get_field('color');
?>
<article <?php post_class('single-work-tpl'); ?>>

  <div class="top-left">
    <h1 class="work-title"><?php the_title(); ?></h1>
    <?php if($external_url) echo '<a href="'.esc_url($external_url).'" class="external" target="_blank">'.__('Visit the project').'</a>'; ?>
  </div>
  <div class="bottom-left">
    <a href="javascript:void(0);" id="video-play"><?php _e('Play', 'dueper'); ?></a>
    <a href="javascript:void(0);" id="video-pause"><?php _e('Pause', 'dueper'); ?></a>
  </div>
  <div class="bottom-right">
    <div id="video-duration">
      <span id="video-time">0:00</span> / <span id="video-total">0:00</span>
    </div><!--video-duration-->
  </div>
  <div class="top-right">
    <?php if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') : ?>
      <a href="javascript:void(0);" class="close-video" id="close-video"><?php _e('Exit', 'dueper'); ?></a>
    <?php else: ?>
      <a href="<?php echo esc_url(site_url('')); ?>" class="close-video"><?php _e('Projects', 'dueper'); ?></a>
    <?php endif; ?>
  </div>


  <div class="video-wrapper">
    <video id="main-video" preload>
      <source src="<?php echo $video; ?>" type="video/mp4">
    </video>
    <img src="<?php echo get_template_directory_uri().'/dist/images/play-mouse.svg' ?>" width="64" height="64" id="video-play-btn" />
    <div id="video-percentage"></div>
  </div><!--video-wrapper-->

  <div id="work-overlay-frame">
    <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg" id="work-overlay-frame-svg">
      <rect x="0" y="0" width="100%" height="100%" id="work-overlay-frame-rect" />
    </svg>
  </div>
</article>
