<?php
if ( ! function_exists('member_CPT_creator') ) {

  // Register Custom Post Type
  function member_CPT_creator() {

  	$labels = array(
  		'name'                  => _x( 'Team Members', 'Post Type General Name', 'dueper' ),
  		'singular_name'         => _x( 'Team Member', 'Post Type Singular Name', 'dueper' ),
  		'menu_name'             => __( 'Team', 'dueper' ),
  		'name_admin_bar'        => __( 'Team Members', 'dueper' ),
  		'archives'              => __( 'Team Members Archives', 'dueper' ),
  		'parent_item_colon'     => __( 'Parent Team Member:', 'dueper' ),
  		'all_items'             => __( 'All Team Members', 'dueper' ),
  		'add_new_item'          => __( 'Add New Team Member', 'dueper' ),
  		'add_new'               => __( 'Add New', 'dueper' ),
  		'new_item'              => __( 'New Team Member', 'dueper' ),
  		'edit_item'             => __( 'Edit Team Member', 'dueper' ),
  		'update_item'           => __( 'Update Team Member', 'dueper' ),
  		'view_item'             => __( 'View Item', 'dueper' ),
  		'search_items'          => __( 'Search Item', 'dueper' ),
  		'not_found'             => __( 'Not found', 'dueper' ),
  		'not_found_in_trash'    => __( 'Not found in Trash', 'dueper' ),
  		'featured_image'        => __( 'Featured Image', 'dueper' ),
  		'set_featured_image'    => __( 'Set featured image', 'dueper' ),
  		'remove_featured_image' => __( 'Remove featured image', 'dueper' ),
  		'use_featured_image'    => __( 'Use as featured image', 'dueper' ),
  		'insert_into_item'      => __( 'Insert into Team Member', 'dueper' ),
  		'uploaded_to_this_item' => __( 'Uploaded to this Team Member', 'dueper' ),
  		'items_list'            => __( 'Team Members list', 'dueper' ),
  		'items_list_navigation' => __( 'Team Members list navigation', 'dueper' ),
  		'filter_items_list'     => __( 'Filter Team Members list', 'dueper' ),
  	);
  	$args = array(
  		'label'                 => __( 'Team Member', 'dueper' ),
  		'labels'                => $labels,
  		'supports'              => array( 'title', 'author', 'revisions', ),
  		'taxonomies'            => array(),
  		'hierarchical'          => false,
  		'public'                => true,
  		'show_ui'               => true,
  		'show_in_menu'          => true,
  		'menu_position'         => 5,
  		'menu_icon'             => 'dashicons-id-alt',
  		'show_in_admin_bar'     => true,
  		'show_in_nav_menus'     => false,
  		'can_export'            => true,
  		'has_archive'           => true,
  		'exclude_from_search'   => false,
  		'publicly_queryable'    => true,
  		'capability_type'       => 'page',
  	);
  	register_post_type( 'member', $args );

  }
  add_action( 'init', 'member_CPT_creator', 0 );

}
