<?php
// ------------------------------------------------------
// Includo ACF pro
// ---------------

// Includo ACF PRO
include_once( get_stylesheet_directory() . '/vendor/acf_pro/acf.php' );

// Customizzo il path di ACF con quello del tema/vendor/acf_pro
function my_acf_settings_path( $path ) {
  $path = get_stylesheet_directory() . '/vendor/acf_pro/';
  // return
  return $path;
}
add_filter('acf/settings/path', 'my_acf_settings_path');


// Customizzo la dir di ACF con quello del tema/vendor/acf_pro
function my_acf_settings_dir( $dir ) {
  // update path
  $dir = get_stylesheet_directory_uri() . '/vendor/acf_pro/';
  // return
  return $dir;
}
add_filter('acf/settings/dir', 'my_acf_settings_dir');

// Nascondo ACF field group dal menu principale
// add_filter('acf/settings/show_admin', '__return_false');

// Cambio la cartella di destinazione dei Json
function my_acf_json_save_point( $path ) {
  // update path
  $path = get_stylesheet_directory() . '/functions/init/custom-fields/acf-json';
  // return
  return $path;
}
add_filter('acf/settings/save_json', 'my_acf_json_save_point');

//Aggiungo la KEY di GoogleMaps
add_filter('acf/settings/google_api_key', function () {
    return 'AIzaSyB8OJXvqDQvUyLEyplu39BaVhtu6Q_OAMM';
});

// ---------------
// FINE: Includo ACF pro
// ------------------------------------------------------

if( function_exists('acf_add_options_page') ) {
  if (!function_exists('dueper_add_options_pages')) {
    add_action( 'init', 'dueper_add_options_pages' );
    function dueper_add_options_pages(){
      $general_conf = acf_add_options_page(array(
        'page_title' 	=> 'Configurazioni generali',
        'menu_title' 	=> 'Configurazioni',
        'menu_slug' 	=> 'theme-general-conf',
        'capability' 	=> 'edit_others_pages',//Editor
        'redirect'    => true,
        'icon_url'    => 'dashicons-welcome-view-site'
      ));

      acf_add_options_sub_page(array(
        'page_title' 	=> 'Opzioni generali',
        'menu_title' 	=> 'Generali',
        'parent_slug' 	=> $general_conf['menu_slug'],
      ));
      acf_add_options_sub_page(array(
        'page_title' 	=> 'Opzioni avanzate',
        'capability'  => 'update_core',
        'menu_title' 	=> 'Avanzate',
        'parent_slug' 	=> $general_conf['menu_slug'],
      ));

      $social_page = acf_add_options_page(array(
        'page_title' 	=> 'Account social',
        'menu_title' 	=> 'Social',
        'menu_slug' 	=> 'theme-social-account',
        'capability' 	=> 'edit_others_pages',//Editor
        'redirect'    => true,
        'icon_url'    => 'dashicons-share'
      ));

      //Add custom field group
      require_once(get_template_directory().'/functions/init/custom-fields/general.php');
      require_once(get_template_directory().'/functions/init/custom-fields/advanced.php');
      require_once(get_template_directory().'/functions/init/custom-fields/social-accounts.php');
    }
  }
}
