<?php
$video = get_field('video_bg');
$text = get_field('intro_text');
?>

<div class="intro-content">
  <img src="<?php echo get_template_directory_uri().'/dist/images/logo-brandcross-white.png'; ?>" id="logo-mega" />
  <div class="intro-text">
    <?php echo $text; ?>
  </div>
</div><!--intro-content-->

<svg id="mouse" width="250" height="185" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <g fill="none">
    <rect id="mouse-outline" x="75" y="3" width="89.333" height="165.333" stroke="#02969C" stroke-width="3" rx="44"/>
    <text id="mouse-text" font-size="18.667" font-weight="500" text-transform="uppercase" letter-spacing="10.667" fill="#fff">
      <tspan x="50%" y="50%" width="100%" text-anchor="middle">
        <?php _e('latest works', 'dueper'); ?>
      </tspan>
    </text>
    <g fill="#02969C" id="mouse-wheel" >
      <circle cx="118.5" cy="32" r="4"/>
    </g>
  </g>
</svg>

<?php if($video): ?>
  <video class="hidden-xs" preload autoplay loop>
    <source src="<?php echo $video; ?>" type="video/mp4">
  </video>
<?php endif; ?>
