'use strict';

(function($){

  var memberWrapper = $('.team-members-wrapper');
  var members = memberWrapper.find('.member-teaser');

  var durationValueCache;
  function getDuration () {
    return durationValueCache;
  }
  function updateDuration (e) {
    durationValueCache = window.innerHeight;
  }
  $(window).on("resize", updateDuration); // update the duration when the window size changes
  $(window).triggerHandler("resize"); // set to initial value

  members.each(function(i) {
    var current = $(this);
    var image = current.find('figure img');
    var header = current.find('header');
    var random = Math.floor((Math.random() * 16) + 6);

    var memberCtrl = new ScrollMagic.Controller();
    var memberTimeline = new TimelineMax();

    var directionTween = TweenMax.to(header, 2, { y: '-50%' });

    memberTimeline.add([
      directionTween,
      TweenMax.to(image, 2, { height: "110%", width: "110%", }),
      TweenMax.to(current, 1, { opacity: 1 }),
      TweenMax.to(current, 2, { y: random }),
    ]);

    //set title in animation
    var workkScene = new ScrollMagic.Scene({triggerElement: '.team-members-wrapper', duration: "200%"})
    // .addIndicators({name: "Member"})
    .offset("-200%")
    .setTween(memberTimeline)
    .addTo(memberCtrl);
  });

})(jQuery);
