(function($){
  var body = $('body');
  var isHome = body.hasClass('page-template-page-home');
  var overlay = $('#menu-overlay');
  var menu = $('#main-menu');
  var overlayLeft = overlay.find('.menu-overlay-left');
  var overlayRight = overlay.find('.menu-overlay-right');
  var form = menu.find('.gform_wrapper');
  var menuItems = menu.find('a');

  $(document).bind('gform_confirmation_loaded', function(e, formId){
    var currentForm = $('#gforms_confirmation_message_'+formId);

    TweenMax.set(currentForm, {display: "none", y: -40, opacity: 0 });
    TweenMax.to(currentForm, .6, {display: "block", y: 0, opacity: 1 });
  });


  // — Hamburger menu toggle
  $('.hamburger').click(function() {

    if($(this).hasClass('is-active')) {
      $(this).removeClass('is-active');
      body.trigger('closeMenuOverlay');
    } else {
      $(this).addClass('is-active');
      body.trigger('openMenuOverlay');
    }

  })

  TweenMax.set(overlay, {display: "none", opacity: 0 });

  //OPENING MENU OVERLAY
  body.on('openMenuOverlay', function(){
    var openTimeline = new TimelineMax();
    if(isHome) {
      $.fn.fullpage.setAllowScrolling(false);
      $.fn.fullpage.setKeyboardScrolling(false);
    } else {
      TweenMax.set(body, { overflow: "hidden" });
    }

    if ( window.matchMedia("(min-width: 992px").matches) {
      // DESKTOP
      TweenMax.set(menuItems, {opacity: 0, left: "-100px" });
      TweenMax.set(form, {opacity: 0, y: "-100px" });
      TweenMax.set(overlayLeft, {x: "-10%", y: "0" });
      TweenMax.set(overlayRight, {x: "10%", y: "0" });

      openTimeline.add([
        TweenMax.to(overlay, 1, {display: "block", opacity: 1 }),
        TweenMax.staggerTo(menuItems, 0.7, {opacity: 1, left: "0", ease: Power2.easeOut, delay: 0.4 }, 0.08),
        TweenMax.to(form , 0.5, {opacity: 1, y: "0", ease: Power2.easeOut, delay: 0.4 }),
        TweenMax.to(overlayLeft , 1, {x: "0%", y: "0", ease: Power2.easeOut }),
        TweenMax.to(overlayRight , 1, {x: "0%", y: "0", ease: Power2.easeOut }),
      ]);
    } else {
      // TABLET & mobile
      TweenMax.set(menuItems, {opacity: 0, left: "-30px" });
      TweenMax.set(form, {opacity: 0, x: "-100px" });
      TweenMax.set(overlayLeft, {y: "10%", x: "0" });
      TweenMax.set(overlayRight, {y: "-10%", x: "0" });
      openTimeline.add([
        TweenMax.to(overlay, 1, {display: "block", opacity: 1 }),
        TweenMax.staggerTo(menuItems, 0.7, {opacity: 1, left: "0px", ease: Power2.easeOut, delay: 0.4 }, 0.08),
        TweenMax.to(form , 0.5, {opacity: 1, x: "0", ease: Power2.easeOut, delay: 0.4 }),
        TweenMax.to(overlayLeft , 1, {y: "0%", x: "0", ease: Power2.easeOut }),
        TweenMax.to(overlayRight , 1, {y: "0%", x: "0", ease: Power2.easeOut }),
      ]);
    }

  });

  //CLOSING MENU OVERLAY
  body.on('closeMenuOverlay', function(){
    var openTimeline = new TimelineMax();

    if ( window.matchMedia("(min-width: 992px").matches) {
    // DESKTOP
    openTimeline.add([
      TweenMax.staggerTo(menuItems, 1, {opacity: 0, left: "100px", ease: Power2.easeIn }, 0.1),
      TweenMax.to(form , 0.5, {opacity: 0, y: "100px", ease: Power2.easeIn }),
      TweenMax.to(overlay, 1, { display: "none", opacity: 0, delay: 0.8 }),
      TweenMax.to(overlayLeft , 1, {x: "-10%", y: "0", ease: Power2.easeIn, delay: 0.4 }),
      TweenMax.to(overlayRight , 1, {x: "10%", y: "0", ease: Power2.easeIn, delay: 0.4 }),
    ]);
  } else {
    // TABLET & mobile
    openTimeline.add([
      TweenMax.staggerTo(menuItems, 1, {opacity: 0, left: "30px", ease: Power2.easeIn }, 0.1),
      TweenMax.to(form , 0.5, {opacity: 0, x: "100px", ease: Power2.easeIn }),
      TweenMax.to(overlay, 1, { display: "none", opacity: 0, delay: 0.8 }),
      TweenMax.to(overlayLeft , 1, {y: "10%", x: "0", ease: Power2.easeIn, delay: 0.4 }),
      TweenMax.to(overlayRight , 1, {y: "-10%", x: "0", ease: Power2.easeIn, delay: 0.4 }),
    ]);
  }

    if(isHome) {
      $.fn.fullpage.setAllowScrolling(true);
      $.fn.fullpage.setKeyboardScrolling(false);
    } else {
      openTimeline.add( TweenMax.set(body, { overflow: "auto" }) );
    }
  });

})(jQuery);
