'use strict';

(function($){
  var body = $('body');
  var isHome = body.hasClass('page-template-page-home');
  var isWork = body.hasClass('single-work');
  var ajaxcall = $('.work-ajax-call');

  //Ajax on click links
  ajaxcall.click(function(e){
    console.log('FIRE FUNCTION');
    e.preventDefault();
    var href = $(this).attr('href');

    body.trigger('workOverlayCreate');

    var req = $.ajax({
      url: href,
      method: "GET",
      dataType: "html"
    });

    req.done(function(res){
      var overlayContent = $('#work-overlay-content');
      overlayContent.html(res);
      body.trigger('workOverlayIn');
    });

    // On click escape key (maps to keycode `27`) close trigger
    $(document).keyup(function(e) {
      if (e.keyCode == 27) {
        body.trigger('workOverlayOut');
      }
    });

  });

  body.on('workOverlayCreate',function(){
    var overlay = $('<div id="work-overlay"><div id="work-overlay-content"></div><div id="loader"></div></div>');
    if(isHome) {
      $.fn.fullpage.setAllowScrolling(false);
      $.fn.fullpage.setKeyboardScrolling(false);
    }
    body.addClass('overlay-opened');
    body.append(overlay);
    overlay.fadeIn(500, function() {
      body.addClass('loading');
    });
  });

  body.on('workOverlayIn',function(){
    var overlayContent = $('#work-overlay-content');
    var play = $('#work-overlay-content #video-play');
    var pause = $('#work-overlay-content #video-pause');
    var videoPlayBtn = $('#video-play-btn');
    var mainVideo = $('#main-video');

    var inTimeline = new TimelineMax();

    //Fade in overlay
    inTimeline.add( TweenLite.to('#work-overlay-content', .5, {opacity:1, display: 'block'}) );
    //Fade in overlay
    inTimeline.add([
      TweenLite.to('body', 0, {className:'-=loading', delay: 0.7 }),
      TweenLite.to('.video-wrapper', 0.5, {opacity: 1, delay: 0.6}),
      TweenLite.to('#work-overlay-frame-svg', 0.5, { strokeOpacity: 0, delay: 1.1})
    ]);

    var overlayInTweens = [
      TweenLite.set('#work-overlay-content .work-title',  { opacity: 0, left: "-=30px"}),
      TweenLite.to('#work-overlay-content .work-title', 0.8, {opacity: 1, left: "+=30px", ease: Expo.easeOut}),
      TweenLite.set('#work-overlay-content .external',  { opacity: 0, left: "-=30px"}),
      TweenLite.to('#work-overlay-content .external', 0.8, {opacity: 1, left: "+=30px", ease: Expo.easeOut, delay: 0.1}),
      TweenLite.set('#work-overlay-content .close-video',  { opacity: 0, right: "-=30px"}),
      TweenLite.to('#work-overlay-content .close-video', 0.8, {opacity: 1, right: "+=30px", ease: Expo.easeOut, delay: 0.2 }),
      TweenLite.set('#work-overlay-content #video-duration',  { opacity: 0, right: "-=30px"}),
      TweenLite.to('#work-overlay-content #video-duration', 0.8, {opacity: 1, right: "+=30px", ease: Expo.easeOut, delay: 0.4 }),
    ];

    if(bowser.mobile || bowser.tablet) {

      // overlayInTweens = overlayInTweens.concat([
      //   TweenLite.set(pause,  { opacity: 0, display: 'none', left: "-=30px"}),
      //   TweenLite.from(play, 0.8, {opacity: 0, left: "-=30px", ease: Expo.easeOut, delay: 0.3 }),
      // ]);

    } else {
      // overlayInTweens = overlayInTweens.concat([
      //   TweenLite.set(play,  { opacity: 0, display: 'none', left: "-=30px"}),
      //   TweenLite.from(pause, 0.8, {opacity: 0, left: "-=30px", ease: Expo.easeOut, delay: 0.3 }),
      // ]);
    }

    inTimeline.add(overlayInTweens);
    inTimeline.addCallback(function(){
      if(bowser.mobile || bowser.tablet) {
        pause.trigger( "click" );
      } else {
        play.trigger( "click" );
      }
    }, "-=0.80");

    inTimeline.play();

    //Attivo il close sul click dell'exit
    $('#work-overlay-content #close-video').click(function(e){
      e.preventDefault();
      body.trigger('workOverlayOut');
    });


    var video = $('#work-overlay-content #main-video');
    var loadBar = $('#work-overlay-content #video-percentage');
    //Faccio partire il video

    //Animo la progressbar
    video.bind('timeupdate',function(e){
      var loadedPercentage = ( 100 * this.currentTime ) / this.duration;
      TweenMax.to(loadBar, 0.6, { width: loadedPercentage + '%', ease: Power0.easeNone });

      function addZero(num) {
      	(String(num).length < 2) ? num = String("0" + num) :  num = String(num);
      	return num;
      }

      //Video duration
      var durationMinutes = parseInt(this.duration / 60, 10);
		  var durationSeconds = Math.round( this.duration % 60 );
      var videoDuration = durationMinutes + ':' + addZero(durationSeconds);

      //CurretTime
      var currentTimeMinutes = parseInt(this.currentTime / 60, 10);
		  var currentTimeSeconds = Math.round( this.currentTime % 60 );
      var videoCurrentTime = currentTimeMinutes + ':' + addZero(currentTimeSeconds);

      $('#work-overlay-content #video-total').text(videoDuration);

      $('#work-overlay-content #video-time').text(videoCurrentTime);
    });

    mainVideo.click(function(e){
      e.preventDefault();
      if(mainVideo.hasClass('playing')){
        pause.trigger('click');
      } else {
        play.trigger('click');
      }
    });

    play.click(function(e){
      e.preventDefault();
      video.get(0).play();
      mainVideo.addClass('playing');
      TweenLite.to(pause, 0.8, {opacity: 1, left: "0px", display: 'block', ease: Expo.easeOut });
      TweenLite.to(play, 0.8, {opacity: 0, left: "30px", display: 'none', ease: Expo.easeOut });
      TweenLite.to(videoPlayBtn, 0.8, {opacity: 0, display: 'none', ease: Expo.easeOut });
      TweenLite.to(mainVideo, 0.4, {webkitFilter:"blur(0px)" });
    });
    pause.click(function(e){
      e.preventDefault();
      video.get(0).pause();
      mainVideo.removeClass('playing');
      TweenLite.to(pause, 0.8, {opacity: 0, left: "30px", display: 'none', ease: Expo.easeOut });
      TweenLite.to(play, 0.8, {opacity: 1, left: "0px", display: 'block', ease: Expo.easeOut });
      TweenLite.to(videoPlayBtn, 0.8, {opacity: 1, display: 'block', ease: Expo.easeOut });
      TweenLite.to(mainVideo, 0.8, {webkitFilter:"blur(10px)" });
    });

  });

  body.on('workOverlayOut',function(){
    var overlay = $('#work-overlay');
    var overlayContent = $('#work-overlay-content');
    var outTimeline = new TimelineMax();

    //Faccio il fadeout del volume dell'audio
    $('#work-overlay-content #main-video').animate({volume: 0}, 1000);

    //Creo la timeline per l'uscita
    outTimeline.add( [
      TweenLite.to('.video-wrapper', 0.5, {opacity: 0 }),
      TweenLite.to('#work-overlay-content .work-title', 0.8, {opacity: 0, left: "+=30px", ease: Expo.easeOut}),
      TweenLite.to('#work-overlay-content .external', 0.8, {opacity: 0, left: "+=30px", ease: Expo.easeOut, delay: 0.1}),
      TweenLite.to('#work-overlay-content .close-video', 0.8, {opacity: 0, right: "+=30px", ease: Expo.easeOut, delay: 0.2 }),
      TweenLite.to('#work-overlay-content #video-play', 0.8, {opacity: 0, left: "+=30px", ease: Expo.easeOut, delay: 0.3 }),
      TweenLite.to('#work-overlay-content #video-pause', 0.8, {opacity: 0, left: "+=30px", ease: Expo.easeOut, delay: 0.3 }),
      TweenLite.to('#work-overlay-content #video-duration', 0.8, {opacity: 0, right: "+=30px", ease: Expo.easeOut, delay: 0.4 }),
    ]);
    outTimeline.add([
      TweenLite.to('#work-overlay-content', 0.5, {opacity:0, display: 'none'}),
      TweenLite.to('#work-overlay', 1.2, {opacity:0, display: 'none'})
    ]);
    outTimeline.add( TweenLite.to('body', 0, {className:'-=overlay-opened'}) );
    if(isHome) {
      $.fn.fullpage.setAllowScrolling(true);
      $.fn.fullpage.setKeyboardScrolling(true);
    }

    outTimeline.eventCallback('onComplete', function(){
      overlay.remove();
    });

  });

  window.onload = function() {
    if(isWork) {
      body.trigger('workOverlayIn');
    }
  };

  function resizeText() {
    $('.work-teaser-small .work-title').textfill({
       maxFontPixels: 20,
    })
    $('.work-teaser-small .category-mobile').textfill({
       maxFontPixels: 14,
    })
  }

  $(window).on('load resize', resizeText);
  resizeText();
})(jQuery);
