'use strict';

(function($){

  var work = $('.work-teaser');
  var windowH = $(window).height();

  /*
  * Creo le animazioni per i WORK in homepage
  */

  //Duplico il comportamento per ogni .work-teaser
  work.each(function(i, el){

    // console.log(i);

    // init controller
    var current = $(this);
    var title = this.getElementsByClassName('work-title');
    var category = this.getElementsByClassName('category');
    var content = this.getElementsByClassName('work-content');
    var image = this.getElementsByClassName('work-image');
    var right = this.getElementsByClassName('right');
    var color = current.attr('data-color');

    var mainCtrl = new ScrollMagic.Controller();
    var opacityCtrl = new ScrollMagic.Controller();
    var bgCtrl = new ScrollMagic.Controller();

    var mainTimeline = new TimelineMax();
    var opacityTimeline = new TimelineMax();
    var bgTimeline = new TimelineMax();

    var durationValueCache;
    function getDuration () {
      return durationValueCache;
    }
    function updateDuration (e) {
      durationValueCache = window.innerHeight;
    }

    $(window).on("resize", updateDuration); // update the duration when the window size changes
    $(window).triggerHandler("resize"); // set to initial value


    //TITLE
    TweenMax.set(title, {left: "-=100px", opacity: 0});
    TweenMax.set(content, {left: "+=50px", opacity: 0});
    TweenMax.set(category, {letterSpacing: "6vw", opacity: 0});
    TweenMax.set(right, {opacity: 0.3});
    TweenMax.set(right, {y: "-100%"});
    TweenMax.set(image, {y: "45%"});
    // TweenMax.set(right, {webkitFilter:"blur(5px)"});
    // TweenMax.set(right, {backgroundPositionX:"0"});
    // TweenMax.set(right, {width:"40%"});

    mainTimeline.add([
      TweenMax.to(title, 1, {left: "+=100px", top: "+=25%", ease: Power0.easeNone }),
      TweenMax.to(content, 1, {left: "-=100px", ease: Power0.easeNone }),
      TweenMax.to(category, 1, {letterSpacing: "1vw", ease: Power0.easeNone }),
      TweenMax.to($('body'), 0.5, { backgroundColor: color }),
      TweenMax.to(right, 1, { opacity: 0.8, ease: Power0.easeNone }),
      // TweenMax.to(right, 1, { backgroundPositionX:"50px", ease: Power0.easeNone }),
    ]);

    bgTimeline.add([
      TweenMax.to(right, 3, { y: "100%", ease: Power0.easeNone }),
      TweenMax.to(image, 3, { y: "-45%", ease: Power0.easeNone })
    ]);

    //opacityTimeline
    opacityTimeline.add([
      TweenMax.to(title, 1, {opacity: 1, ease: Power0.easeNone }),
      TweenMax.to(content, 1, {opacity: 1, ease: Power0.easeNone }),
      TweenMax.to(category, 1, {opacity: 1, delay: 0.3, ease: Power0.easeNone }),
      // TweenMax.to(right, 1, { webkitFilter:"blur(0px)", ease: Power0.easeNone }),
    ]);
    opacityTimeline.add([
      TweenMax.to(title, 1, {opacity: 0, delay: 1, ease: Power0.easeNone }),
      TweenMax.to(content, 1, {opacity: 0, delay: 1, ease: Power0.easeNone }),
      TweenMax.to(category, 1, {opacity: 0, delay: 1, ease: Power0.easeNone}),
    ]);

    //set title in animation
    var workkScene = new ScrollMagic.Scene({triggerElement: this, duration: "150%"})
    // .addIndicators({name: "Main"})
    // .offset("-200%")
    .setTween(mainTimeline)
    .addTo(mainCtrl);


    //set title in animation
    var bgScene = new ScrollMagic.Scene({triggerElement: this, duration: "150%"})
    // addOffset(-(windowH*1.33))
    // .addIndicators({name: "Bg"})
    .setTween(bgTimeline)
    .addTo(bgCtrl);


    var opacityScene = new ScrollMagic.Scene({triggerElement: this, duration: "140%"})
    // .addIndicators({name: "Opacity"})
    // .offset("-200%")
    .setTween(opacityTimeline)
    .addTo(opacityCtrl);

  });
})(jQuery);
