<?php
/**
 * Template Name: Contatti
 * This template is used for display contact page
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

wp_enqueue_script('gmaps-API','https://maps.googleapis.com/maps/api/js?key=AIzaSyB8OJXvqDQvUyLEyplu39BaVhtu6Q_OAMM&v=3.exp&sensor=false');

get_header();

$location = get_field('map');
$gmaps = get_field('google_maps_link');
$text = get_field('intro_text');

while ( have_posts() ) : the_post(); ?>

	<div class="intro-wrapper">
		<?php if($location): ?>
		  <div class="acf-map">
	      <div class="marker"
           data-lat="<?php echo $location['lat']; ?>"
           data-lng="<?php echo $location['lng']; ?>"
           data-icon="<?php echo get_template_directory_uri().'/dist/images/map-marker.png'; ?>"></div>
		  </div><!--acf-map-->
		<?php endif; ?>

		<?php if($gmaps): ?>
			<a href="<?php echo esc_url($gmaps); ?>" class="view-on-gmaps" target="_blank"><?php _e('View on Google Maps', 'dueper'); ?></a>
		<?php endif; ?>

		<?php if($text): ?>
	    <h2 class="intro-title"><?php echo $text; ?></h2>
	  <?php endif; ?>

		<svg id="mouse" width="203" height="185" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
	    <g fill="none">
	      <rect id="mouse-outline" x="60.333" y="3" width="89.333" height="165.333" stroke="#02969C" stroke-width="3" rx="44"/>
	      <text id="mouse-text" font-size="18.667" font-weight="500" text-transform="uppercase" letter-spacing="10.667" fill="#fff">
	        <tspan x="50%" y="50%" width="100%" text-anchor="middle">
	          <?php the_title(); ?>
	        </tspan>
	      </text>
	      <g fill="#02969C" id="mouse-wheel" >
	        <circle cx="105.667" cy="32" r="4"/>
	      </g>
	    </g>
	  </svg>

	</div>
	</header><!-- .page-header -->
	<div class="contact-wrapper">
		<div class="text-content">
			<?php the_content(); ?>
			<div class="infos-wrapper">
				<?php if(get_field('phone')): ?>
					<div class="phone">
						<span class="label"><?php _e('Phone', 'dueper'); ?> // </span> <?php the_field('phone'); ?>
					</div><!--phone-->
				<?php endif; ?>

				<?php if(get_field('fax')): ?>
					<div class="fax">
						<span class="label"><?php _e('Fax', 'dueper'); ?> // </span> <?php the_field('fax'); ?>
					</div><!--fax-->
				<?php endif; ?>

				<?php if(get_field('email')): ?>
					<div class="email">
						<span class="label"><?php _e('Email', 'dueper'); ?> // </span> <a href="mailto:<?php echo sanitize_email(get_field('email')); ?>"><?php echo sanitize_email(get_field('email')); ?></a>
					</div><!--email-->
				<?php endif; ?>
			</div><!--infos-wrapper-->

			<div class="social">
				<span class="label">
					<?php _e('Follow us on :', 'Dueper'); ?>
				</span>
				<?php get_template_part('includes/socialbar/_socialbar'); ?>
			</div>

		</div><!--text-content-->
	</div><!--contact-wrapper-->

<?php endwhile;
get_footer(); ?>
