<?php
/**
 * Template Name: Homepage
 * This template is used for display frontpage
 *
 * @author Dueper Design
 * @package Dueper Theme
 */

$introbg = get_field('image_bg');
$args = array(
 'post_type'  => 'work',
 'posts_per_page' => 5,
);
$projects = new WP_Query($args);


get_header(); ?>

  <div id="home-page">
    <section class="home-section" id="intro" data-anchor="intro" style="background-image:url('<?php if($introbg) echo $introbg['url']; ?>')">
      <?php get_template_part('includes/home/_home-intro'); ?>
    </section>

    <?php
    $i = 1;
    if($projects->have_posts()):
      while($projects->have_posts()): $projects->the_post(); ?>
        <section class="home-section" data-anchor="<?php echo $i; ?>">
          <?php get_template_part('partials/teaser/_teaser','work'); ?>
        </section>
      <?php $i++;
      endwhile;
    endif;
    wp_reset_query(); ?>

    <section id="credits" class="home-section fp-auto-height" data-anchor="">
        <?php the_field('credits', 'option'); ?>
    </section>

  </div><!--home-page-->

  <svg width="66px" id="project-hover" height="66px" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <polygon id="Triangle" stroke="#46999d" stroke-width="4" transform="translate(35.500000, 32.000000) rotate(90.000000) translate(-35.500000, -32.000000) " points="35.5 21.5 48.5 42.5 22.5 42.5"></polygon>
    <path d="M32,64 C49.673112,64 64,49.673112 64,32 C64,14.326888 49.673112,8.52651283e-14 32,8.52651283e-14 C14.326888,8.52651283e-14 0,14.326888 0,32 C0,49.673112 14.326888,64 32,64 Z" id="Oval-1" stroke="#FFFFFF" stroke-width="3"></path>
  </svg>

  <?php if($projects->have_posts()):
    $i = 1;?>
    <ul id="home-menu">
      <?php while($projects->have_posts()): $projects->the_post(); ?>
        <li data-menuanchor="<?php echo $i; ?>">
          <a href="#<?php echo $i; ?>">
            <span class="label">
              <?php echo romanic_number($i); ?>
            </span>
          </a>
        </li>
      <?php $i++;
      endwhile; ?>
    </ul>
  <?php endif;
  wp_reset_query(); ?>

<?php get_footer(); ?>
