<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the id=main div and all content after
 *
 * @author Dueper Design
 * @package Dueper Theme1
 */
?>
  <?php //get_template_part('inc/_blanka-cookie-bar');?>
  <?php
    $blogname = get_bloginfo('site_name');
    $credits = get_field('credits','option');
    $link_logo = get_field('link_logo_footer','option');
    $logo_footer = get_template_directory_uri().'/dist/images/antonello_colonna.svg';
  ?>
  <!--progressbar-->
  <div class="progressbar"></div>

  <footer class="site-foot" id="main-footer">
    <a id="book-now" class="button primary hidden-xs hidden-sm"><?php _e('Prenota','blanka');?></a>
    <div class="container clearfix">
      <div class="footer-top">
        <div class="row row-padding">
          <div class="col-xs-1-2">
            <?php if($link_logo) echo '<a target="_blank" class="logo-footer" href="'.$link_logo.'">' ;?>
              <?php echo "<img class='site-logo' src='{$logo_footer}' alt='{$blogname}' />"; ?>
            <?php if($link_logo) echo '</a>'; ?>
          </div>
          <div class="col-xs-1-2">
            <?php get_template_part('inc/footer/_company-data');?>
            <?php get_template_part('inc/socialbar/_socialbar');?>
          </div>
        </div>
      </div>
    </div>
    <hr />
    <div class="container clearfix">
      <div class="footer-bottom">
        <div class="row row-padding">
          <div class="col-1-1 col-sm-1-2">
            <?php get_template_part('inc/footer/_group');?>
          </div><!--col-sm-1-4-->
          <?php if ( has_nav_menu( 'footer-menu-1' ) ||  has_nav_menu( 'footer-menu-2' )) :?>
            <div class="col-1-1 col-sm-1-2">
              <div class="row footer-bottom-widget">
                <div class="col-1-1 col-xs-1-2">
                  <?php
                    $args = array(
                      'theme_location' => 'footer-menu-1',
                      'items_wrap' => '<ul id="%1$s" class="%2$s"><li class="before-redline"></li>%3$s</ul>',
                      'menu_class' => '',
                      'fallback_cb' => '',
                      'menu_id' => 'footer-menu-one',
                    );
                    wp_nav_menu($args);
                  ?>
                </div>
                <div class="col-1-1 col-xs-1-2">
                  <?php
                    $args = array(
                      'theme_location' => 'footer-menu-2',
                      'items_wrap' => '<ul id="%1$s" class="%2$s"><li class="before-redline"></li>%3$s</ul>',
                      'menu_class' => '',
                      'fallback_cb' => '',
                      'menu_id' => 'footer-menu-two',
                    );
                    wp_nav_menu($args);
                  ?>
                </div>
              </div>
          </div><!--col-sm-1-4-->
          <?php endif;?>
        </div><!--row-->
      </div>
    </div><!--container-->
    <div class="credits">
      <div class="container small clearfix">
        <div class="row row-padding">
          <?= $credits ?>
        </div>
      </div>
    </div>
  </footer>

  <?php get_template_part('inc/book-now/_overlay-book-now');?>
  <?php get_template_part('inc/menu-mobile/_menu-mobile-overlay');?>

</div><!--#main-container-->
<?php wp_footer(); ?>

</body>
</html>
