<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <main id="main">
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">
  <link rel="profile" href="http://gmpg.org/xfn/11">
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
  <link rel="canonical" href="<?php echo get_permalink();?>" />
  <?php if(!in_array('wordpress-seo/wp-seo.php', apply_filters('active_plugins', get_option('active_plugins')))):?>
    <title><?php wp_title( '&raquo;', true, 'right' ); ?></title>
  <?php endif; ?>
  <?php if(!in_array('sitepress-multilingual-cms/sitepress.php', apply_filters('active_plugins', get_option('active_plugins')))):?>
    <link rel="alternate" type="text/html" hreflang="it" href="<?php echo get_permalink();?>" title="Italiano"/>
  <?php endif; ?>
  <?php /* --- Gestisci i meta di per i social con il plugin Yoast SEO --- */ ?>

  <?php wp_head(); ?>

  <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <?php if(function_exists('the_field')) the_field('google_analytics','option'); ?>
</head>

<body <?php body_class(); ?>>

  <?php do_action('in_body'); ?>

  <div id="main-container">
    
  <?php
  //add hook after header for attach slider, ecc..
  do_action('dueper_after_top_nav'); ?>
