<?php
  $wrapper_width = get_sub_field('wrapper_width');
  $title = get_sub_field('title');
  $focus_posts = get_sub_field('main_news');
  $news_args = array(
    'post_type'=>'post',
    'posts_per_page'  => 2
  );
  $news_posts = new WP_Query($news_args);
?>

<div class="layout-news" id="flex-section-<?php echo get_row_index();?>">
  <?php if($wrapper_width != 'full') echo "<div class='container {$wrapper_width}'>"; ?>
    <?php if($title) echo "<h3 class='layout-title'>{$title}</h3>"; ?>
    <div class="row row-padding">
      <?php if($focus_posts):
        foreach( $focus_posts as $post ): // variable must be called $post (IMPORTANT)
          setup_postdata($post);
          echo '<div class="col-1-1 col-sm-1-2">';
            get_template_part('inc/teaser/_teaser', 'post');
          echo '</div>';
        endforeach;
      elseif($news_posts->have_posts()):
        while($news_posts->have_posts()) : $news_posts->the_post();
          echo '<div class="col-1-1 col-sm-1-2">';
            get_template_part('inc/teaser/_teaser', 'post');
          echo '</div>';
        endwhile;
        wp_reset_query();
      endif; ?>
    </div><!--row-->
  <?php if($wrapper_width != 'full') echo "</div>"; ?>
</div>
