<?php
$logo_img = get_template_directory_uri().'/dist/images/site-brand.svg';
$logo_img_dark = get_template_directory_uri().'/dist/images/site-brand.svg';
$user_icon_default = get_template_directory_uri().'/dist/images/icon-user.svg';
$blogname = get_bloginfo('name');
$company_city = get_field('company_city','option');
$company_address = get_field('company_address','option');
$user = wp_get_current_user();
?>

<nav id="main-header">
  <div class="container-fluid">
    <div class="left-side">
      <a class="logo-header" href="<?php echo esc_url(home_url('/')); ?>">
        <?php echo "<img data-white='{$logo_img}' data-black='{$logo_img_dark}' src='{$logo_img}' alt='{$blogname}' />"; ?>
      </a>
      <div class="company-info">
        <span class="company-city"><?= $company_city;?></span>
        <span class="dot-separator">·</span>
        <span class="company-address"><?= $company_address;?></span>
      </div>
    </div>
    <div class="right-side">
      <div class="top-menu">
        <?php get_template_part('inc/menu/_daily-menu');?>
      </div>
      <button class="hamburger hamburger--slider js-hamburger menu-toggler" type="button" >
        <span class="hamburger-box">
          <span class="hamburger-inner"></span>
        </span>
      </button>
      <div class="login-container">
        <a class="user-toggler" href="my-account">
          <?php if(is_user_logged_in()):?>
            <figure class="user-icon logged">
              <img src="<?= esc_url( get_avatar_url( $user->ID ) ); ?>" />
            </figure>
          <?php else:?>
            <span><?php _e('Login','blanka');?></span>
            <figure class="user-icon">
              <img src="<?= $user_icon_default;?>" alt="<?php _e('Account','woocommerce');?>" />
            </figure>
          <?php endif;?>
        </a>
      </div>
    </div>
  </div><!-- /.container_class -->
</nav>
