(($) => {
  // --DOCUMENT on ready
  $(document).ready(() => {
    // Button To Top
    const button = $('#to-top')
    const topOffset = 100
    button.click(() => {
      $('html, body').animate({ scrollTop: 0 }, 500)
    });
    // Show after 100px offset
    $(window).scroll(() => {
      if ($(this).scrollTop() > topOffset) {
        button.fadeIn()
      } else {
        button.fadeOut()
      }
    });

    // Progressbar
    $(window).scroll(() => {
      // BAR percentage
      const s = $(window).scrollTop()
      const d = $(document).height()
      const c = $(window).height()
      const scrollPercent = (s / (d - c)) * 100
      const progress = `${scrollPercent}%`
      $('.progressbar').width(progress);

      // FLEX NAV lights
      const flexMenu = $('#flex-nav')
      const windowHeight = $(window).height()
      const limitTop = windowHeight * 0.05
      const limitBottom = windowHeight * 0.95

      $('[id^="flex-section"]').each((i, el) => {
        const thisTop = $(el).offset().top - $(window).scrollTop()
        const theID = $(el).attr('id')
        const navEl = flexMenu.find(`li[data-href="${theID}"]`)

        if (thisTop >= limitTop && (thisTop + $(el).height()) <= limitBottom) {
          navEl.addClass('current')
        } else {
          navEl.removeClass('current')
        }
      })
    })

    // SMOOTH SCROLL on all anchors
    $('a.smooth-scroll').click(() => {
      const { location } = window
      if (location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '')
      && location.hostname === this.hostname) {
        let target = $(this.hash)
        target = (target.length && target) || $(`[name=${this.hash.slice(1)}]`)
        if (target.length) {
          const targetOffset = target.offset().top
          $('html,body').animate({ scrollTop: targetOffset }, 1000)
        }
      }
    })
  })
})(jQuery)
