<?php
if ( !function_exists('blanka_breadcrumbs')) {
  function blanka_breadcrumbs() {
    $delimiter = '&raquo;';
    $home = 'Home';
    $before = '<li class="active">';
    $after = '</li>';
    if (!is_home() && !is_front_page() || is_paged()) {
      echo '<ol class="breadcrumb">';
      global $post;
      $homeLink = esc_url(home_url());
      echo '<li><a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . '</li> ';
      if (is_category()) {
        global $wp_query;
        $cat_obj = $wp_query->get_queried_object();
        $thisCat = $cat_obj->term_id;
        $thisCat = get_category($thisCat);
        $parentCat = get_category($thisCat->parent);
        if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
        echo $before . single_cat_title('', false) . $after;
      } elseif (is_day()) {
        echo '<li><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        echo '<li><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_time('d') . $after;
      } elseif (is_month()) {
        echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_time('F') . $after;
      } elseif (is_year()) {
        echo $before . get_the_time('Y') . $after;
      } elseif (is_single() && !is_attachment()) {
        if ( get_post_type() != 'post' ) {
          $post_type = get_post_type_object(get_post_type());
          $slug = $post_type->rewrite;
          echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a></li> ' . $delimiter . ' ';
          echo $before . get_the_title() . $after;
        } else {
          $cat = get_the_category(); $cat = $cat[0];
          echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
          echo $before . get_the_title() . $after;
        }
      } elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
        $post_type = get_post_type_object(get_post_type());
        echo $before . $post_type->labels->singular_name . $after;
      } elseif (is_attachment()) {
        $parent = get_post($post->post_parent);
        $cat = get_the_category($parent->ID); $cat = $cat[0];
        echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
        echo $before . get_the_title() . $after;
      } elseif ( is_page() && !$post->post_parent ) {
        echo $before . get_the_title() . $after;
      } elseif ( is_page() && $post->post_parent ) {
        $parent_id  = $post->post_parent;
        $breadcrumbs = array();
        while ($parent_id) {
          $page = get_page($parent_id);
          $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
          $parent_id  = $page->post_parent;
        }
        $breadcrumbs = array_reverse($breadcrumbs);
        foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
        echo $before . get_the_title() . $after;
      } elseif ( is_search() ) {
        echo $before . 'Search results for "' . get_search_query() . '"' . $after;
      } elseif ( is_tag() ) {
        echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
      } elseif ( is_author() ) {
        global $author;
        $userdata = get_userdata($author);
        echo $before . 'Articles posted by ' . $userdata->display_name . $after;
      } elseif ( is_404() ) {
        echo $before . 'Error 404' . $after;
      }
      if ( get_query_var('paged') ) {
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
        echo ': ' . __('Page', 'blanka') . ' ' . get_query_var('paged');
        if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
      }
      echo '</ol>';
    }
  }
}

// if ( !function_exists('blanka_schema_breadcrumbs')) {
//   function blanka_schema_breadcrumbs() {
//     global $post;
//     //schema link
//     $schema_link = 'http://data-vocabulary.org/Breadcrumb';
//     $home = 'Home';
//     $delimiter = ' &raquo; ';
//     $homeLink = get_bloginfo('url');
//     if (is_home() || is_front_page()) {
//     // no need for breadcrumbs in homepage
//     }
//     else {
//     echo '<div id="mpbreadcrumbs">';
//     // main breadcrumbs lead to homepage
//     if (!is_single()) {
//     echo 'You are here: ';
//     }
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . $homeLink . '">' . '<span itemprop="title">' . $home . '</span>' . '</a></span>' . $delimiter . ' ';
//     // if blog page exists
//     if (get_page_by_path('blog')) {
//     if (!is_page('blog')) {
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_permalink(get_page_by_path('blog')) . '">' . '<span itemprop="title">Blog</span></a></span>' . $delimiter . ' ';
//     }
//     }
//     if (is_category()) {
//     $thisCat = get_category(get_query_var('cat'), false);
//     if ($thisCat->parent != 0) {
//     $category_link = get_category_link($thisCat->parent);
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . $category_link . '">' . '<span itemprop="title">' . get_cat_name($thisCat->parent) . '</span>' . '</a></span>' . $delimiter . ' ';
//     }
//     $category_id = get_cat_ID(single_cat_title('', false));
//     $category_link = get_category_link($category_id);
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . $category_link . '">' . '<span itemprop="title">' . single_cat_title('', false) . '</span>' . '</a></span>';
//     }
//     elseif (is_single() && !is_attachment()) {
//     if (get_post_type() != 'post') {
//     $post_type = get_post_type_object(get_post_type());
//     $slug = $post_type->rewrite;
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . $homeLink . '/' . $slug['slug'] . '">' . '<span itemprop="title">' . $post_type->labels->singular_name . '</span>' . '</a></span>';
//     echo ' ' . $delimiter . ' ' . get_the_title();
//     }
//     else {
//     $category = get_the_category();
//     if ($category) {
//     foreach ($category as $cat) {
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_category_link($cat->term_id) . '">' . '<span itemprop="title">' . $cat->name . '</span>' . '</a></span>' . $delimiter . ' ';
//     }
//     }
//     echo get_the_title();
//     }
//     }
//     elseif (!is_single() && !is_page() && get_post_type() != 'post' && !is_404()) {
//     $post_type = get_post_type_object(get_post_type());
//     echo $post_type->labels->singular_name;
//     }
//     elseif (is_attachment()) {
//     $parent = get_post($post->post_parent);
//     $cat = get_the_category($parent->ID);
//     $cat = $cat[0];
//     echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_permalink($parent) . '">' . '<span itemprop="title">' . $parent->post_title . '</span>' . '</a></span>';
//     echo ' ' . $delimiter . ' ' . get_the_title();
//     }
//     elseif (is_page() && !$post->post_parent) {
//     $get_post_slug = $post->post_name;
//     $post_slug = str_replace('-', ' ', $get_post_slug);
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_permalink() . '">' . '<span itemprop="title">' . ucfirst($post_slug) . '</span>' . '</a></span>';
//     }
//     elseif (is_page() && $post->post_parent) {
//     $parent_id = $post->post_parent;
//     $breadcrumbs = array();
//     while ($parent_id) {
//     $page = get_page($parent_id);
//     $breadcrumbs[] = '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_permalink($page->ID) . '">' . '<span itemprop="title">' . get_the_title($page->ID) . '</span>' . '</a></span>';
//     $parent_id = $page->post_parent;
//     }
//     $breadcrumbs = array_reverse($breadcrumbs);
//     for ($i = 0; $i < count($breadcrumbs); $i++) {
//     echo $breadcrumbs[$i];
//     if ($i != count($breadcrumbs) - 1)
//     echo ' ' . $delimiter . ' ';
//     }
//     echo $delimiter . '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_permalink() . '">' . '<span itemprop="title">' . the_title_attribute('echo=0') . '</span>' . '</a></span>';
//     }
//     elseif (is_tag()) {
//     $tag_id = get_term_by('name', single_cat_title('', false), 'post_tag');
//     if ($tag_id) {
//     $tag_link = get_tag_link($tag_id->term_id);
//     }
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . $tag_link . '">' . '<span itemprop="title">' . single_cat_title('', false) . '</span>' . '</a></span>';
//     }
//     elseif (is_author()) {
//     global $author;
//     $userdata = get_userdata($author);
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_author_posts_url($userdata->ID) . '">' . '<span itemprop="title">' . $userdata->display_name . '</span>' . '</a></span>';
//     }
//     elseif (is_404()) {
//     echo 'Error 404';
//     }
//     elseif (is_search()) {
//     echo 'Search results for "' . get_search_query() . '"';
//     }
//     elseif (is_day()) {
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_year_link(get_the_time('Y')) . '">' . '<span itemprop="title">' . get_the_time('Y') . '</span>' . '</a></span>' . $delimiter . ' ';
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . '<span itemprop="title">' . get_the_time('F') . '</span>' . '</a></span>' . $delimiter . ' ';
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')) . '">' . '<span itemprop="title">' . get_the_time('d') . '</span>' . '</a></span>';
//     }
//     elseif (is_month()) {
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_year_link(get_the_time('Y')) . '">' . '<span itemprop="title">' . get_the_time('Y') . '</span>' . '</a></span>' . $delimiter . ' ';
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_month_link(get_the_time('Y'), get_the_time('m')) . '">' . '<span itemprop="title">' . get_the_time('F') . '</span>' . '</a></span>';
//     }
//     elseif (is_year()) {
//     echo '<span itemscope itemtype="' . $schema_link . '"><a itemprop="url" href="' . get_year_link(get_the_time('Y')) . '">' . '<span itemprop="title">' . get_the_time('Y') . '</span>' . '</a></span>';
//     }
//     if (get_query_var('paged')) {
//     if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author())
//     echo ' (';
//     echo __('Page') . ' ' . get_query_var('paged');
//     if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author())
//     echo ')';
//     }
//     echo '</div>';
//     }
//   }
// }
