<?php

// Remove additional profile info
if (!function_exists('dueper_remove_profile_fields')) {
  add_filter('user_contactmethods','dueper_remove_profile_fields', 10, 2);
  function dueper_remove_profile_fields( $contactmethods ) {
    unset($contactmethods['aim']);
    unset($contactmethods['jabber']);
    unset($contactmethods['yim']);
    return $contactmethods;
  }
}

// Add featured image in RSS
if ( !function_exists('dueper_rss_post_thumbnail')) {
  add_filter('the_excerpt_rss', 'dueper_rss_post_thumbnail', 10, 2);
  add_filter('the_content_feed', 'dueper_rss_post_thumbnail', 10, 2);
  function dueper_rss_post_thumbnail($content) {
    global $post;
    if(has_post_thumbnail($post->ID)) :
      $content = '<p>' . get_the_post_thumbnail($post->ID) .
      '</p>' . get_the_content();
    endif;
    return $content;
  }
}

// Revising Default Excerpt
if ( !function_exists('bootstrapwp_excerpt')) {
  add_filter('excerpt_more', 'bootstrapwp_excerpt', 10, 2);
  function bootstrapwp_excerpt($more) {
    global $post;
    return '...';
  }
}

//Revising Default Excerpt
if ( !function_exists('dueper_excerpt_length')) {
  add_filter( 'excerpt_length', 'dueper_excerpt_length', 10, 2 );
  function dueper_excerpt_length( $length ) {
    return 10;
  }
}

// Localize admin-ajax
if ( !function_exists('frontend_enqueued_scripts')) {
function frontend_enqueued_scripts() {
    wp_localize_script( 'custom', 'ajax_posts', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'noposts' => __('No older posts found', 'blanka'),
    ));
  }
  add_action( 'wp_enqueue_scripts', 'frontend_enqueued_scripts' );
}

//Wrap oEmbed with container
function oembed_wrapper($html, $url, $attr, $post_id) {
  return "<div class='video-responsive'>{$html}</div>";
}
add_filter('embed_oembed_html','oembed_wrapper',10,3);
