<?php
// Custom Smart Signage Functions

if ( !function_exists('get_current_menu')) {
  function get_current_menu($time) {
    $mdg_colazione = get_field('mdg_colazione','option');
    $mdg_pranzo = get_field('mdg_pranzo','option');
    $mdg_hour = get_field('mdg_hour','option');
    $mdg_cena = get_field('mdg_cena','option');
    $orario_col = get_field('orario_colazione','option');
    $orario_col_end = get_field('orario_colazione_termine','option');
    // * PRANZO *
    $orario_pra = get_field('orario_pranzo','option');
    $orario_pra_end = get_field('orario_pranzo_termine','option');
    // * MAGIC HOUR *
    $orario_mag = get_field('orario_magic','option');
    $orario_mag_end = get_field('orario_magic_termine','option');
    // * CENA *
    $orario_cen = get_field('orario_cena','option');
    $orario_cen_end = get_field('orario_cena_termine','option');

    switch ($time) {
      case ($time >= $orario_col_end && $time < $orario_pra_end) :
        $current_mdg = $mdg_pranzo;
      break;
      case ($time >= $orario_pra_end && $time < $orario_mag_end) :
        $current_mdg = $mdg_hour;
      break;
      case ($time >= $orario_mag_end && $time < $orario_cen_end) :
        $current_mdg = $mdg_cena;
      break;
      case ($time >= $orario_cen_end || $time < $orario_col_end) :
        $current_mdg = $mdg_colazione;
      break;
    }

    return $current_mdg;
  }
}

if ( !function_exists('get_current_menu_title') && function_exists('get_current_menu')) {
  function get_current_menu_title($time) {
    $menu = get_current_menu($time);
    $cat = get_the_terms($menu, 'menu_timing');
    return $cat[0]->name;
  }
}

if ( !function_exists('get_current_menu_timing')) {
  function get_current_menu_timing($time) {
    // * COLAZIONE *
    $orario_col = get_field('orario_colazione','option');
    $orario_col_end = get_field('orario_colazione_termine','option');
    // * PRANZO *
    $orario_pra = get_field('orario_pranzo','option');
    $orario_pra_end = get_field('orario_pranzo_termine','option');
    // * MAGIC HOUR *
    $orario_mag = get_field('orario_magic','option');
    $orario_mag_end = get_field('orario_magic_termine','option');
    // * CENA *
    $orario_cen = get_field('orario_cena','option');
    $orario_cen_end = get_field('orario_cena_termine','option');

    switch ($time) {
      case ($time >= $orario_col_end && $time < $orario_pra_end) :
        $current_title = 'Dalle '.$orario_pra.' alle '.$orario_pra_end;
      break;
      case ($time >= $orario_pra_end && $time < $orario_mag_end) :
        $current_title = 'Dalle '.$orario_mag.' alle '.$orario_mag_end;
      break;
      case ($time >= $orario_mag_end && $time < $orario_cen_end) :
        $current_title = 'Dalle '.$orario_cen.' alle '.$orario_cen_end;
      break;
      case ($time >= $orario_cen_end || $time < $orario_col_end) :
        $current_title = 'Dalle '.$orario_col.' alle '.$orario_col_end;
      break;
    }

    return $current_title;
  }
}

if ( !function_exists('get_next_menu')) {
  function get_next_menu($time) {
    $mdg_colazione = get_field('mdg_colazione','option');
    $mdg_pranzo = get_field('mdg_pranzo','option');
    $mdg_hour = get_field('mdg_hour','option');
    $mdg_cena = get_field('mdg_cena','option');
    $orario_col = get_field('orario_colazione','option');
    $orario_col_end = get_field('orario_colazione_termine','option');
    // * PRANZO *
    $orario_pra = get_field('orario_pranzo','option');
    $orario_pra_end = get_field('orario_pranzo_termine','option');
    // * MAGIC HOUR *
    $orario_mag = get_field('orario_magic','option');
    $orario_mag_end = get_field('orario_magic_termine','option');
    // * CENA *
    $orario_cen = get_field('orario_cena','option');
    $orario_cen_end = get_field('orario_cena_termine','option');

    switch ($time) {
      case ($time >= $orario_col_end && $time < $orario_pra_end) :
        $next_mdg = $mdg_hour;
      break;
      case ($time >= $orario_pra_end && $time < $orario_mag_end) :
        $next_mdg = $mdg_cena;
      break;
      case ($time >= $orario_mag_end && $time < $orario_cen_end) :
        $next_mdg = $mdg_colazione;
      break;
      case ($time >= $orario_cen_end || $time < $orario_col_end) :
        $next_mdg = $mdg_pranzo;
      break;
    }
    return $next_mdg;
  }
}

if ( !function_exists('get_next_menu_title') && function_exists('get_next_menu')) {
  function get_next_menu_title($time) {
    $menu = get_next_menu($time);
    $cat = get_the_terms($menu, 'menu_timing');
    return $cat[0]->name;
  }
}

if ( !function_exists('get_next_menu_timing')) {
  function get_next_menu_timing($time) {
    // * COLAZIONE *
    $orario_col = get_field('orario_colazione','option');
    $orario_col_end = get_field('orario_colazione_termine','option');
    // * PRANZO *
    $orario_pra = get_field('orario_pranzo','option');
    $orario_pra_end = get_field('orario_pranzo_termine','option');
    // * MAGIC HOUR *
    $orario_mag = get_field('orario_magic','option');
    $orario_mag_end = get_field('orario_magic_termine','option');
    // * CENA *
    $orario_cen = get_field('orario_cena','option');
    $orario_cen_end = get_field('orario_cena_termine','option');

    switch ($time) {
      case ($time >= $orario_col_end && $time < $orario_pra_end) :
        $next_title = 'Dalle '.$orario_mag.' alle '.$orario_mag_end;
      break;
      case ($time >= $orario_pra_end && $time < $orario_mag_end) :
        $next_title = 'Dalle '.$orario_cen.' alle '.$orario_cen_end;
      break;
      case ($time >= $orario_mag_end && $time < $orario_cen_end) :
        $next_title = 'Dalle '.$orario_col.' alle '.$orario_col_end;
      break;
      case ($time >= $orario_cen_end || $time < $orario_col_end) :
        $next_title = 'Dalle '.$orario_pra.' alle '.$orario_pra_end;
      break;
    }

    return $next_title;
  }
}
