<?php
// Loading All CSS Stylesheets
if (!function_exists('load_css_files')) {
  add_action('wp_enqueue_scripts', 'load_css_files');
  function load_css_files() {
    //SASS
    wp_enqueue_style('main', get_template_directory_uri().'/dist/css/styles.min.css');
    wp_enqueue_style('vendor', get_template_directory_uri().'/dist/css/vendor.min.css');
    wp_enqueue_style('style', get_template_directory_uri().'/style.css');
  }
}

// Loading all JS Script Files.
if (!function_exists('load_js_files')) {
  add_action('wp_enqueue_scripts', 'load_js_files');
  function load_js_files() {
    //Original
    wp_enqueue_script('vendor', get_template_directory_uri().'/dist/js/vendor.min.js', array('jquery'),'1.0', true);
    wp_enqueue_script('gmaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyBsuj8bQz3GjKRjMPuO8S3svzkI5uM3lo8', array('jquery'), null, true);
    wp_enqueue_script('main', get_template_directory_uri().'/dist/js/main.min.js', array('jquery'),'1.0', true );
  }
}
