<?php

// My Allergens list
function my_allergens_list() {
  global $current_user;
  $current_user_id = get_current_user_id();
  $current_user_allergens_id = get_field('allergens', 'user_'. $current_user_id );

  if ( is_user_logged_in() ) {
    $allergen_list = '<ul class="user-allergens-name-list">';
    
    foreach ($current_user_allergens_id as $allergen) {
      $allergen_term = get_term( $allergen, 'allergen' );
      $allergen_list .= '<li>' . $allergen_term->name . '<span>,&nbsp;</span></li>';
    }
    
    $allergen_list .= '</ul>';

    return $allergen_list;

  } else {
  }
}
add_action( 'allergens_list', 'my_allergens_list' );

// My Allergens Icons
function my_allergen_icons() {
  $current_user_id = get_current_user_id();
  $current_user_allergens_id = get_field('allergens', 'user_'. $current_user_id );

  $allergen_icon = '<div class="user-allergens-icons">';

  foreach ($current_user_allergens_id as $allergen) {
    $allergen_term = get_term( $allergen, 'allergen' );
    $red_icon = get_field('red_icon', 'allergen_' . $allergen);
    $red_icon_url = $red_icon['url'];

    $allergen_icon .= '<figure class="allergen-container">';
    $allergen_icon .= '<img src="' . $red_icon_url . '" alt="' . $allergen_term->name . '"/>';
    $allergen_icon .= '</figure>';
  }

  $allergen_icon .= '</div>';

  return $allergen_icon;
}
add_action( 'allergen_icons', 'my_allergen_icons' );