<?php
if (!function_exists('dueper_image_sizes')) {
  add_action( 'init', 'dueper_register_nav_menus' );
  function dueper_register_nav_menus(){
    $menus = array(
      'main-menu' => __( 'Main Menu', 'blanka' ),
      'footer-menu-1' => __( 'Footer Menu 1', 'blanka' ),
      'footer-menu-2' => __( 'Footer Menu 2', 'blanka' ),
    //  'main-menu-left' => __( 'Main Menu Left', 'blanka' ),
    //  'main-menu-right' => __( 'Main Menu Right', 'blanka' )
    );
    register_nav_menus($menus);
  }
}

//Add custom menu item
if (!function_exists('customize_menu_item')) {
//  add_filter( 'wp_nav_menu_items', 'customize_menu_item', 10, 2 );
  function customize_menu_item ( $items, $args ) {
    if($args->theme_location == 'main-menu'):
      $items .= '<li><a href="#" title="'.__('Customize','blanka').'">'.__('Customize','blanka').' <span class="dashicons dashicons-screenoptions"></span></a><li>';
      $items .= '<li><a href="#" title="'.__('Search','blanka').'"><span class="dashicons dashicons-search"></span></a><li>';
    endif;
    return $items;
  }
}

// Add Language selector in menu
if(function_exists('icl_get_languages')){
  if (!function_exists('bootstrap_languages_menu_item')) {
    add_filter( 'wp_nav_menu_items', 'bootstrap_languages_menu_item',  10, 2);
    function bootstrap_languages_menu_item($items, $args){
      $languages = icl_get_languages('skip_missing=0&orderby=code');
      if($languages):
          if($args->theme_location == 'main-menu' && get_field('lang_selector_toggle', 'option')):
              $items .= '<li class="menu-item-language"><a href="#" class="dropdown-toggle">'._x("Languages", "menu", "dueper").' <b class="caret"></b></a><ul class="dropdown-menu">';
              foreach($languages as $l) :
                  if(!$l['active']) :
                      $items .= '<li><a href="'.$l['url'].'">'.$l['native_name'].'</a>';
                  else :
                      $items .= '<li class="active"><a href="'.$l['url'].'">'.$l['native_name'].'</a>';
                  endif;
              endforeach;
              $items .= '</ul></li>';
          endif;
      endif;

      return $items;
    }
  }
}
