<?php 
$wrapper_width = get_sub_field('wrapper_width');
?>

<div class="layout-columns" id="flex-section-<?php echo get_row_index();?>">
    <?php if($wrapper_width != 'full') echo "<div class='inner-wrapper container {$wrapper_width}'>"; ?>
        <div class="row">
            <?php if( have_rows('accordion') ): ?>
                <div class="accordion-container">
                    <?php while( have_rows('accordion') ): the_row(); 
                        $panel_title = get_sub_field('panel_title');
                        $panel_text = get_sub_field('panel_text');
                        $panel_image = get_sub_field('panel_image');
                    ?>
                    <div class="accordion-panel">
                        <div class="accordion-toggle">
                            <h3 class="accordion-panel-title">
                                <?= $panel_title; ?>
                                <span class="small-plus"></span>
                            </h3>
                        </div>
                        <div class="accordion-panel-body">
                            <div class="accordion-panel-body-inner">
                                <?= $panel_text; ?>
                                <figure>
                                    <img src="<?= $panel_image['url']; ?>" alt="<?= $panel_image['alt'] ?>" />
                                </figure>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php if($wrapper_width != 'full') echo "</div>"; ?>
</div>