<?php
$index = get_row_index();
$wrapper_width = get_sub_field('wrapper_width');
?>

<div class="layout-map" id="flex-section-<?php echo get_row_index();?>">
  <?php if($wrapper_width != 'full') echo "<div class='container {$wrapper_width}'>"; ?>
    <?php if( have_rows('markers') ): ?>
      <div class="map" id="map-<?= $index; ?>">
        <?php while( have_rows('markers') ): the_row();
          $icon = get_sub_field('icon');
          $address = get_sub_field('address');
          $geo_position = get_sub_field('geo_position');
          ?>

          <div class="marker"
          data-icon="<?= $icon['url'] ?>"
          data-lat="<?= $geo_position['lat'] ?>"
          data-lng="<?= $geo_position['lng'] ?>">
            <?php if($address) echo $address; ?>
          </div><!--marker-->
        <?php endwhile; ?>
      </div>
    <?php endif; ?>

  <?php if($wrapper_width != 'full') echo "</div>"; ?>
</div>


<script>
(function($) {
  $(document).on('ready', function(){
  	$("#map-<?= $index; ?>").each(function(){
  		renderMap( $(this) );
  	});
  });
})(jQuery);

</script>
