<?php
  date_default_timezone_set('Europe/Rome');
  
  // * MENU DEL GIORNO *
  $mdg_colazione = get_field('mdg_colazione','option');
  $mdg_pranzo = get_field('mdg_pranzo','option');
  $mdg_hour = get_field('mdg_hour','option');
  $mdg_cena = get_field('mdg_cena','option');
  // * COLAZIONE *
  $orario_col = get_field('orario_colazione','option');
  $testo_col = get_sub_field('testo_colazione');
  $media_type_col = get_sub_field('media_type_colazione');
  $video_col = get_sub_field('video_colazione');
  $immagine_col = get_sub_field('immagine_colazione');
  $fallback_col = get_sub_field('fallback_colazione');
  // * PRANZO *
  $orario_pra = get_field('orario_pranzo','option');
  $testo_pra = get_sub_field('testo_pranzo');
  $media_type_pra = get_sub_field('media_type_pranzo');
  $video_pra = get_sub_field('video_pranzo');
  $immagine_pra = get_sub_field('immagine_pranzo');
  $fallback_pra = get_sub_field('fallback_pranzo');
  // * MAGIC HOUR *
  $orario_mag = get_field('orario_magic','option');
  $testo_mag = get_sub_field('testo_magic');
  $media_type_mag = get_sub_field('media_type_magic');
  $video_mag = get_sub_field('video_magic');
  $immagine_mag = get_sub_field('immagine_magic');
  $fallback_mag = get_sub_field('fallback_magic');
  // * CENA *
  $orario_cen = get_field('orario_cena','option');
  $testo_cen = get_sub_field('testo_cena');
  $media_type_cen = get_sub_field('media_type_cena');
  $video_cen = get_sub_field('video_cena');
  $immagine_cen = get_sub_field('immagine_cena');
  $fallback_cen = get_sub_field('fallback_cena');

  // * GENERAL INFO *
  $hour = get_sub_field('hour');
  $address = get_sub_field('address');
  $icon_player = get_template_directory_uri().'/dist/images/icon-play.svg';

  
  function get_minutes_from_hour($time) {
    $hour = date('H', strtotime($time)) * 60;
    $minutes = date('i', strtotime($time));

    return intval($hour + $minutes);
  }

  $colazione = array(
    'menu' => get_field('mdg_colazione', 'option'),
    'start' => get_minutes_from_hour(get_field('orario_colazione', 'option')),
    'end' => get_minutes_from_hour(get_field('orario_colazione_termine', 'option')),
    'start_label' => get_field('orario_colazione', 'option'),
    'end_label' => get_field('orario_colazione_termine', 'option'),
  );
  $pranzo = array(
    'menu' => get_field('mdg_pranzo', 'option'),
    'start' => get_minutes_from_hour(get_field('orario_pranzo', 'option')),
    'end' => get_minutes_from_hour(get_field('orario_pranzo_termine', 'option')),
    'start_label' => get_field('orario_pranzo', 'option'),
    'end_label' => get_field('orario_pranzo_termine', 'option'),
  );
  $magic_hour = array(
    'menu' => get_field('mdg_hour', 'option'),
    'start' => get_minutes_from_hour(get_field('orario_magic', 'option')),
    'end' => get_minutes_from_hour(get_field('orario_magic_termine', 'option')),
    'start_label' => get_field('orario_magic', 'option'),
    'end_label' => get_field('orario_magic_termine', 'option'),
  );

  $cena = array(
    'menu' => get_field('mdg_cena', 'option'),
    'start' => get_minutes_from_hour(get_field('orario_cena', 'option')),
    'end' => get_minutes_from_hour(get_field('orario_cena_termine', 'option')),
    'start_label' => get_field('orario_cena', 'option'),
    'end_label' => get_field('orario_cena_termine', 'option'),
  );

?>

<div class="layout-menu-landing" id="flex-section-<?php echo get_row_index();?>">
  <div class="background-container">
  <?php if(current_time('H:i') >= $orario_col  && current_time('H:i') <= $orario_pra) :?>
    <div class="layer colazione <?= $media_type_col ?>">
      <?php if($media_type_col === 'video' && $video_col):?>
        <div class="video-wrapper">
          <video width="100%" height="100%" autoplay loop muted>
            <source src="<?= $video_col['url'] ?>" type="<?= $video_col['mime_type'] ?>">
          </video>
        </div>
      <?php elseif($media_type_col === 'immagine' && $immagine_col): ?>
        <figure>
          <img
            src="<?= $immagine_col['sizes']['full_hd'] ?>"
            alt="<?= $immagine_col['alt'] ?>"
            title="<?= $immagine_col['title'] ?>"
            longdesc="<?= $immagine_col['caption'] ?>"
          />
        </figure>
      <?php endif; ?>
      <figure class="mobile-fallback">
        <?php if($fallback_col): ?>
          <img
            src="<?= $fallback_col['sizes']['full_hd'] ?>"
            alt="<?= $fallback_col['alt'] ?>"
            title="<?= $fallback_col['title'] ?>"
            longdesc="<?= $fallback_col['caption'] ?>"
          />
        <?php elseif($immagine_col): ?>
          <img
              src="<?= $immagine_col['sizes']['full_hd'] ?>"
              alt="<?= $immagine_col['alt'] ?>"
              title="<?= $immagine_col['title'] ?>"
              longdesc="<?= $immagine_col['caption'] ?>"
            />
        <?php endif; ?>
      </figure>
    </div>
    <?php elseif(current_time('H:i') >= $orario_pra  && current_time('H:i') <= $orario_magic) :?>
    <div class="layer pranzo <?= $media_type_pra ?>">
      <?php if($media_type_pra === 'video' && $video_pra):?>
        <div class="video-wrapper">
          <video width="100%" height="100%" autoplay loop muted>
            <source src="<?= $video_pra['url'] ?>" type="<?= $video_pra['mime_type'] ?>">
          </video>
        </div>
      <?php elseif($media_type_pra === 'immagine' && $immagine_pra): ?>
        <figure>
          <img
            src="<?= $immagine_pra['sizes']['full_hd'] ?>"
            alt="<?= $immagine_pra['alt'] ?>"
            title="<?= $immagine_pra['title'] ?>"
            longdesc="<?= $immagine_pra['caption'] ?>"
          />
        </figure>
      <?php endif; ?>
       <figure class="mobile-fallback">
        <?php if($fallback_pra): ?>
          <img
            src="<?= $fallback_pra['sizes']['full_hd'] ?>"
            alt="<?= $fallback_pra['alt'] ?>"
            title="<?= $fallback_pra['title'] ?>"
            longdesc="<?= $fallback_pra['caption'] ?>"
          />
        <?php elseif($immagine_pra): ?>
          <img
              src="<?= $immagine_pra['sizes']['full_hd'] ?>"
              alt="<?= $immagine_pra['alt'] ?>"
              title="<?= $immagine_pra['title'] ?>"
              longdesc="<?= $immagine_pra['caption'] ?>"
            />
        <?php endif; ?>
      </figure>
    </div>
    <?php elseif(current_time('H:i') >= $orario_magic  && current_time('H:i') <= $orario_cen) :?>
    <div class="layer magic <?= $media_type_mag ?>">
      <?php if($media_type_mag === 'video' && $video_mag):?>
        <div class="video-wrapper">
          <video width="100%" height="100%" autoplay loop muted>
            <source src="<?= $video_mag['url'] ?>" type="<?= $video_mag['mime_type'] ?>">
          </video>
        </div>
      <?php elseif($media_type_mag === 'immagine' && $immagine_mag): ?>
        <figure>
          <img
            src="<?= $immagine_mag['sizes']['full_hd'] ?>"
            alt="<?= $immagine_mag['alt'] ?>"
            title="<?= $immagine_mag['title'] ?>"
            longdesc="<?= $immagine_mag['caption'] ?>"
          />
        </figure>
      <?php endif; ?>
       <figure class="mobile-fallback">
        <?php if($fallback_mag): ?>
          <img
            src="<?= $fallback_mag['sizes']['full_hd'] ?>"
            alt="<?= $fallback_mag['alt'] ?>"
            title="<?= $fallback_mag['title'] ?>"
            longdesc="<?= $fallback_mag['caption'] ?>"
          />
        <?php elseif($immagine_mag): ?>
          <img
              src="<?= $immagine_mag['sizes']['full_hd'] ?>"
              alt="<?= $immagine_mag['alt'] ?>"
              title="<?= $immagine_mag['title'] ?>"
              longdesc="<?= $immagine_mag['caption'] ?>"
            />
        <?php endif; ?>
      </figure>
    </div>
    <?php elseif(current_time('H:i') >= $orario_cen  && current_time('H:i') <= $orario_col) :?>
    <div class="layer cena <?= $media_type_cen ?>">
      <?php if($media_type_cen === 'video' && $video_cen):?>
        <div class="video-wrapper">
          <video width="100%" height="100%" autoplay loop muted>
            <source src="<?= $video_cen['url'] ?>" type="<?= $video_cen['mime_type'] ?>">
          </video>
        </div>
      <?php elseif($media_type_cen === 'immagine' && $immagine_cen): ?>
        <figure>
          <img
            src="<?= $immagine_cen['sizes']['full_hd'] ?>"
            alt="<?= $immagine_cen['alt'] ?>"
            title="<?= $immagine_cen['title'] ?>"
            longdesc="<?= $immagine_cen['caption'] ?>"
          />
        </figure>
      <?php endif; ?>
       <figure class="mobile-fallback">
        <?php if($fallback_cen): ?>
          <img
            src="<?= $fallback_cen['sizes']['full_hd'] ?>"
            alt="<?= $fallback_cen['alt'] ?>"
            title="<?= $fallback_cen['title'] ?>"
            longdesc="<?= $fallback_cen['caption'] ?>"
          />
        <?php elseif($immagine_cen): ?>
          <img
              src="<?= $immagine_cen['sizes']['full_hd'] ?>"
              alt="<?= $immagine_cen['alt'] ?>"
              title="<?= $immagine_cen['title'] ?>"
              longdesc="<?= $immagine_cen['caption'] ?>"
            />
        <?php endif; ?>
      </figure>
    </div>
  <?php endif; ?>
  </div>

  <a href="#" class="graph-player">
    <img src="<?= $icon_player ?>" />
  </a>

  <div id="clock-wrapper">
    <?= current_time('H:i') ?>
  </div>

  <div class="central-graph">
    <?php
    include( locate_template( 'inc/circle-menu-info.php', false, false ) );
    include( locate_template( 'inc/circle-menu-svg.php', false, false ) );
    ?>
  </div>

  <div class="info-wrapper">
    <?php if($hour):?>
      <time><?= $hour ?></time>
    <?php endif; ?>
    <?php if($address):?>
      <address><!--<span>: </span> --><?= $address ?></address>
    <?php endif; ?>
  </div>
</div>