<?php
  $dishes = get_field('piatti');
  $cibo_cat = get_term_by('slug', 'food', 'product_cat');
  $food_categories = get_terms([
    'taxonomy' => 'product_cat',
    'child_of' => $cibo_cat->term_id
  ]);

  $current_user_id = get_current_user_id();
  $current_user_allergens_id = get_field('allergens', 'user_'. $current_user_id );
?>

<div class="menu-container-panel">
  <div class="scrolling-line"></div>
  <?php foreach($food_categories as $food_cat) :?>
    <?php 
      $query_food = new WP_Query(array(
        'post_type'      	=> 'product',
        'posts_per_page'	=> -1,
        'post__in'			=> $dishes,
        'post_status'		=> 'any',
        'orderby'        	=> 'post__in',
        'tax_query' => array(
          array(
            'taxonomy' => 'product_cat',
            'field'    => 'slug',
            'terms'    => $food_cat->slug,
          ),
        ),
      ));
      if ($query_food->have_posts()) :
    ?>
      <section class="food-area" data-mh>
        <h4 class="food-area-title"><?= $food_cat->name;?></h4>
        <ul class="dishes">
          <?php while($query_food->have_posts()) : $query_food->the_post();?>
            <?php $allergens = wp_get_post_terms($post->ID, 'allergen');?>
            <li>
              <span class="dish-title"><?php the_title();?></span>
              <?php if($allergens):?>
                <?php
                  $out_black = array();
                  $out_red = array();
                  
                  foreach ($allergens as $allergen) :?>
                  <?php
                    $allergen_id = $allergen->term_id;
                    $all_allergens_id = array($allergen_id);
                    
                    $black_icon = get_field('black_icon', 'allergen_' . $allergen_id);
                    $black_icon_url = $black_icon['url'];
                    $red_icon = get_field('red_icon', 'allergen_' . $allergen_id);
                    $red_icon_url = $red_icon['url'];

                    $out_black[] = '<figure class="allergen-container">';
                    $out_black[] .= '<img src="'.$black_icon_url.'" ';
                    $out_black[] .= 'alt="'.$allergen->name.'"/>';
                    $out_black[] .= '</figure>';
                    $out_red[] = '<figure class="allergen-container">';
                    $out_red[] .= '<img src="'.$red_icon_url.'" ';
                    $out_red[] .= 'alt="'.$allergen->name.'"/>';
                    $out_red[] .= '</figure>';

                    $my_allergens = array_intersect($current_user_allergens_id, $all_allergens_id);

                  ?>
                <?php endforeach;?>

                <?php if(is_user_logged_in() && $my_allergens):?>
                  <?= join( $out_red );?>
                <?php else:?>
                <?php endif;?>

              <?php endif;?>

              <?php 
                $product = new WC_Product(get_the_ID());
                $price = $product->get_price_html();
                print $price;
              ?>

            </li>
          <?php endwhile;?>
        </ul>
      </section>
    <?php endif; wp_reset_query();?> 
  <?php endforeach;?>
</div>