<?php
global $current_user;
$current_user_id = get_current_user_id();
$current_user_allergens_id = get_field('allergens', 'user_'. $current_user_id );

$image['placeholder'] = blanka_get_the_post_thumbnail_url(get_the_ID(), 'medium');
$image['default'] = blanka_get_the_post_thumbnail_url(get_the_ID(), 'full_hd');
$image['retina'] = blanka_get_the_post_thumbnail_url(get_the_ID(), 'full_hd');

$show_dishes = get_field('show_dishes');
$pre_title = get_field('pre_title');
$dishes = get_field('piatti');
?>

<div class="single-standard">
  <header class="menu-header">
    <figure>
      <img class="lazy" src="<?= $image['placeholder'] ?>" data-src="<?= $image['default'] ?>" data-src-retina="<?= $image['retina'] ?>" alt="<?php the_title(); ?>" />
      <figcaption>
        <div class="menu-type-title">
          <?php if($pre_title): ?>
            <?php _e($pre_title,'blanka');?>
            <?php else:?>
            <?php _e('Menu del giorno','blanka');?>
          <?php endif;?>
        </div>
        <h1><?php the_title(); ?></h1>
      </figcaption>
    </figure>
  </header>
  
  <?php if( is_user_logged_in() && !empty($current_user_allergens_id) ):?>
    <?php get_template_part('inc/user/_user-allergens-message');?>
  <?php else:?>
  <?php endif;?>
  
  <?php if($show_dishes && $dishes): ?>
    <div class="menu-container">
      <div class="container">
        <div class="menu-header">
          <?php _e('Menu','blanka');?>
        </div>
        <?php get_template_part('inc/menu/_menu-container');?>
      </div>
    </div>
  <?php endif; ?>
 
  <?php get_template_part('inc/flexible-layout/index'); ?>
  <!-- DETACHABLE FIXED NAVIGATION -->
  <?php get_template_part('inc/flexible-layout/_flex-nav'); ?>

</div><!--single-standard-->

<?php if( function_exists('the_blogpost_json_ld') ):
  the_blogpost_json_ld($post->ID);
endif; ?>
