const $ = jQuery;

const addMarker = (m, map) => {
  const latlng = new google.maps.LatLng(m.attr('data-lat'), m.attr('data-lng'))
  const marker = new google.maps.Marker({
    position: latlng,
    map,
    icon: m.attr('data-icon')
  })
  map.markers.push(marker)
  if (m.html()) {
    const infowindow = new google.maps.InfoWindow({
      content: m.html()
    })
    google.maps.event.addListener(marker, 'click', () => {
      infowindow.open(map, marker)
    })
  }
}

const centerMap = (marker, map) => {
  const bounds = new google.maps.LatLngBounds()

  $.each(map.markers, (i, m) => {
    const latlng = new google.maps.LatLng(m.position.lat(), m.position.lng())
    bounds.extend(latlng)
  })
  if (map.markers.length === 1) {
    map.setCenter(bounds.getCenter())
    map.setZoom(14)
  } else {
    map.fitBounds(bounds)
  }
}

const renderMap = (el) => {
  const markers = el.find('.marker')
  const styles = []
  const args = {
    zoom: 14,
    scrollwheel: false,
    center: new google.maps.LatLng(0, 0),
    mapTypeId: google.maps.MapTypeId.ROADMAP,
    styles,
  }
  const map = new google.maps.Map(el[0], args)

  map.markers = [];
  markers.each(function addMarkertoMap() {
    addMarker($(this), map)
  })
  centerMap($('.marker'), map)
  $(window).resize(() => {
    centerMap($('.marker'), map)
  })
}
