<?php 
  $allergen_terms = get_terms( array(
    'taxonomy' => 'allergen',
    'hide_empty' => false,
  ));

  $current_user_id = get_current_user_id();
  $current_user_allergens_id = get_field('allergens', 'user_'. $current_user_id );
?>

<div class="user-allergens-select">
  <div class="">
    <p><?php _e('Seleziona i tuoi allergeni.','blanka');?></p>
  </div>
  <div class="user-allergens-form-container">
    <form class="user-allergens-form" action="" method="post">
      <?php foreach($allergen_terms as $allergen_term):?>
        <?php 
          $allergen_terms_id = $allergen_term->term_id;
          $all_allergens_id = array($allergen_terms_id);

          $my_allergens = array_intersect($current_user_allergens_id, $all_allergens_id);

          $black_icon = get_field('black_icon', 'allergen_' . $allergen_terms_id);
          $black_icon_url = $black_icon['url'];
          $red_icon = get_field('red_icon', 'allergen_' . $allergen_terms_id);
          $red_icon_url = $red_icon['url'];
        ?>
        <div class="user-allergens-form-row row <?php if($my_allergens):?>checked<?php endif;?>">
          <figure class="allergen-container">
            <?php if($my_allergens):?>
              <img src="<?= $red_icon_url;?>" alt="<?= $allergen_term->name;?>"/>
            <?php else :?>
              <img src="<?= $black_icon_url;?>" alt="<?= $allergen_term->name;?>"/>
            <?php endif;?>
          </figure>
          <div class="allergen-name">
            <?= $allergen_term->name;?>
          </div>
          <input 
            type="checkbox" 
            class="check-allergen" 
            name="<?= $allergen_term->name;?>" 
            id="<?= $allergen_term->name;?>" 
            value="<?= $allergen_term->name;?>"
            <?php if($my_allergens):?>checked<?php endif;?>
          />
        </div>
      <?php endforeach;?>
      <div class="user-allergens-form-button row">
        <button type="submit" class="button button-primary" name="save_allergens_details" value="<?php _e( 'Salva', 'blanka' ); ?>"><?php _e( 'Salva', 'blanka' ); ?></button>
        <input type="hidden" name="action" value="save_allergens_details" />
      </div>
    </form>
  </div>
</div>