<?php
/**
 * My Account page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="my-account-header">
  <div class="my-account-header-inner">
    <div class="my-account-user-message">
      <?php
        /* translators: 1: user display name 2: logout url */
        printf(
          __( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ),
          '<span>' . esc_html( $current_user->display_name ) . '</span>',
          esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
        );
      ?>
    </div>
    <div class="my-account-user-message-bottom">
      <?php _e('Here you can keep track...','blanka');?>
    </div>
  </div>
</div>

<div class="my-account-content-wrapper">
  <div class="container">
    <div class="row">
      <div class="col-1-3" data-mh>
        <?php 
            /**
            * My Account navigation.
            *
            * @since 2.6.0
            */
            do_action( 'woocommerce_account_navigation' );
          ?>
      </div><!--col-->
      <div class="col-2-3">
        <div class="content-wrapper" data-mh>
          <?php
            /**
             * My Account content.
             *
             * @since 2.6.0
             */
            do_action( 'woocommerce_account_content' );
          ?>
        </div>
      </div>
    </div>
  </div><!--container-->
</div>
