<?php

// Disable all Woocommerce default styles
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

// Declaring WooCommerce support
function blanka_add_woocommerce_support() {
  add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'blanka_add_woocommerce_support' );


function blanka_allergens_account_menu_items( $items ) {

  $items[__( 'allergeni', 'blanka' )] = __( 'Allergeni', 'blanka' );

  unset( $items['orders'] );
  unset( $items['downloads'] );
  unset( $items['edit-address'] );

  return $items;
}
add_filter( 'woocommerce_account_menu_items', 'blanka_allergens_account_menu_items', 9999, 1 );

function allergens_add_my_account_endpoint() {
  add_rewrite_endpoint( 'allergeni', EP_PAGES );
}
add_action( 'init', 'allergens_add_my_account_endpoint' );

function allergens_information_endpoint_template() {
  wc_get_template( 'myaccount/allergeni.php' );
}
add_action( 'woocommerce_account_allergeni_endpoint', 'allergens_information_endpoint_template' );