<?php
add_theme_support( 'editor-styles' );
// add_theme_support( 'dark-editor-style' ); // Dark bg
add_theme_support( 'align-wide' ); // Alignment wide
add_theme_support( 'responsive-embeds' ); // Embed resposive classes
add_theme_support( 'wp-block-styles' );


//Colors
add_theme_support( 'disable-custom-colors' );
add_theme_support( 'editor-color-palette', array(
  array(
      'name' => __( 'strong magenta', 'themeLangDomain' ),
      'slug' => 'strong-magenta',
      'color' => '#a156b4',
  ),
  array(
      'name' => __( 'light grayish magenta', 'themeLangDomain' ),
      'slug' => 'light-grayish-magenta',
      'color' => '#d0a5db',
  ),
  array(
      'name' => __( 'very light gray', 'themeLangDomain' ),
      'slug' => 'very-light-gray',
      'color' => '#eee',
  ),
  array(
      'name' => __( 'very dark gray', 'themeLangDomain' ),
      'slug' => 'very-dark-gray',
      'color' => '#444',
  ),
));


//Font sizes
// add_theme_support('disable-custom-font-sizes');
add_theme_support( 'editor-font-sizes', array(
  array(
      'name' => __( 'Small', 'themeLangDomain' ),
      'size' => 13,
      'slug' => 'small'
  ),
  array(
      'name' => __( 'Normal', 'themeLangDomain' ),
      'size' => 16,
      'slug' => 'normal'
  ),
  array(
      'name' => __( 'Large', 'themeLangDomain' ),
      'size' => 36,
      'slug' => 'large'
  ),
  array(
      'name' => __( 'Huge', 'themeLangDomain' ),
      'size' => 50,
      'slug' => 'huge'
  )
) );

//custom styles
add_editor_style( './dist/css/gutenberg/gutenberg.min.css' );



/**
 * Block template for posts
 * @see https://www.billerickson.net/gutenberg-block-templates/
 *
*/
function be_post_block_template() {
  //Creo un template per un post
  $post_type_object = get_post_type_object( 'post' );
  $post_type_object->template = array(
    array( 'core/paragraph', array(
      'placeholder' => 'Inserisci qui il sottotiolo',
    ) ),
    array( 'core/image', array(
      'align' => 'wide',
    ) ),
    array( 'core/freeform', array(
      'placeholder' => 'Inserisci il contenuto'
    )),
  );
  $post_type_object->template_lock = 'all';
}
add_action( 'init', 'be_post_block_template' );