<?php

date_default_timezone_set('Europe/Rome');

$menus = [
  $colazione,
  $pranzo,
  $magic_hour,
  $cena,
];

//function to order menu by start time
function cmp($a, $b) {
  $a_s = new DateTime($a['start_label']);
  $b_s = new DateTime($b['start_label']);

  return $a_s > $b_s;
}

usort($menus, "cmp");
$now = new DateTime(current_time('H:i'));
$initial_slide = 0;
?>



<div class="circle-menu-info">
  <div class="swiper-container">
    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">
      <!-- Slides -->
      <?php
      $index = 0;
      foreach($menus as $menu):
        $menu_start = new DateTime($menu['start_label']);
        $menu_end = new DateTime($menu['end_label']);
        $alt_label = get_field('alt_label', $menu);
        if ($menu_start <= $now && $menu_end >= $now) {
          $initial_slide = $index;
        }
        $index++;
      ?>
        <div class="swiper-slide">
          <div class="circle-menu-info-title">
            <h3><?= $menu['menu']->post_title; ?></h3>
          </div>
          <div class="circle-menu-info-subtitle">
            <time><?= "{$menu['start_label']} - {$menu['end_label']}" ?></time>
            <a
              title="<?= $menu['menu']->post_title; ?>"
              href="<?= get_permalink($menu['menu']->ID); ?>"
            >
              <?php 
              if($alt_label) {
                echo $alt_label;
              } else {
                _e('Scopri il menu','blanka');
              }
              ?>
            </a>
          </div>
          <div class="circle-menu-info-text">
            <?= get_the_excerpt($menu['menu']->ID) ?>
          </div>
        </div><!--swiper-slide-->
      <?php endforeach; ?>
    </div><!--swiper-wrapper-->
  </div><!--swiper-container-->
</div><!--circle-menu-info-->

<script>
  (function($) {
    $(document).on('ready', function() {

      var mySwiper = new Swiper ('.circle-menu-info .swiper-container', {
        initialSlide: <?= $initial_slide ?>,
        loop: true,
        allowTouchMove: false,
      })
    })
  })(jQuery);
</script>