//lazy load
(($) => {
  const calculateDegress = (currentMins, timeStart, timeEnd, degStart, degEnd) => {
    const percentage = (100 * (currentMins - timeStart)) / (timeEnd - timeStart)
    const finalPercentage = (((degEnd - degStart) * percentage) / 100) + degStart

    return finalPercentage
  }

  $(document).ready(() => {
    //Clock
    setInterval(() => {
      const date = new Date();
      let minutes = date.getMinutes();
      minutes = `0${minutes}`.slice(-2)
      
      $('#clock-wrapper').html(`${date.getHours()}:${minutes}`)
    }, 1000)


    $('.layout-menu-landing').each(function menuCircle() {
      const cursor = $(this).find('.cursor');
      const rotationAdjust = 270

      const menu = $(this).find('text[data-menu]')
      const svgItem = $('.svg-menu')

      const menuArray = []
      menu.map((i, el) => {
        menuArray.push({
          menu: $(el).attr('data-menu'),
          name: $(el).attr('data-name'),
          start: Number($(el).attr('data-start')),
          end: Number($(el).attr('data-end')),
          degStart: Number($(el).attr('data-degStart')),
          degEnd: Number($(el).attr('data-degEnd')),
        })
      })
      const animateCursor = () => {
        const today = new Date();
        const minutes = (today.getHours() * 60) + today.getMinutes()
        menuArray.map((el, index) => {
          if (minutes > el.start && minutes < el.end) {
            const subName = el.name.substring(0, el.name.length - 5)
            const currentSegment = svgItem.find('.svg-menu-group[data-name="' + subName + '"]')
            const currentDegrees = calculateDegress(
              minutes,
              el.start,
              el.end,
              el.degStart,
              el.degEnd
            );
            TweenMax.to(cursor, 1, { opacity: 1, rotation: Number(currentDegrees + rotationAdjust) });
            $('.svg-menu-stroke').removeClass('svg-menu-stroke-active')
            currentSegment.find('.svg-menu-stroke').addClass('svg-menu-stroke-active')
            $('.svg-menu-point').removeClass('svg-menu-point-active')
            currentSegment.find('.svg-menu-point').addClass('svg-menu-point-active')
          }
        })
      }

      animateCursor()
      setInterval(animateCursor, 1000);
    })
  })  
})(jQuery)

