<?php
/**
 * Template Name: Smart Signage
 * This template is used for display frontpage
 *
 * @author Dueper Design
 * @package Dueper Theme
 */
get_header('empty'); ?>

<?php
  // $img_opencolonna = get_template_directory_uri().'/dist/images/opencolonna.svg';
  $alt_image = get_field('alt_image');
  $activate_image = get_field('activate_image');

  $alt_image_next = get_field('alt_image_next');
  $activate_image_next = get_field('activate_image_next');

  $current_title = get_field('current_title');
  $current_subtitle = get_field('current_subtitle');

  $next_title = get_field('next_title');
  $next_subtitle = get_field('next_subtitle');

  $disclaimer = get_field('disclaimer');

  if($activate_image && $alt_image):
?>
  <figure class="alternative-bg">
    <img src="<?= $alt_image['sizes']['full_hd'] ?>" />
  </figure>
<?php else:
  // * MENU DEL GIORNO *
  $mdg_colazione = get_field('mdg_colazione','option');
  $mdg_pranzo = get_field('mdg_pranzo','option');
  $mdg_hour = get_field('mdg_hour','option');
  $mdg_cena = get_field('mdg_cena','option');

  // * COLAZIONE *
  $orario_col = get_field('orario_colazione','option');
  $orario_col_end = get_field('orario_colazione_termine','option');
  // * PRANZO *
  $orario_pra = get_field('orario_pranzo','option');
  $orario_pra_end = get_field('orario_pranzo_termine','option');
  // * MAGIC HOUR *
  $orario_mag = get_field('orario_magic','option');
  $orario_mag_end = get_field('orario_magic_termine','option');
  // * CENA *
  $orario_cen = get_field('orario_cena','option');
  $orario_cen_end = get_field('orario_cena_termine','option');

  // $cibo_cat = get_term_by('slug', 'food', 'product_cat');
  date_default_timezone_set('Europe/Rome');
  $date = date('H:i', time());

  // * Get CURRENT & NEXT menu information *
  $current_mdg = get_current_menu($date);
  $default_current_title = get_current_menu_title($date);
  $default_current_subtitle = get_current_menu_timing($date);

  $next_mdg = get_next_menu($date);
  $default_next_title = get_next_menu_title($date);
  $default_next_subtitle = get_next_menu_timing($date);
?>

  <div id="display-menu-wrapper">
    <!-- * CURRENT MENU * -->
    <?php
      if($current_mdg) :
      $post = $current_mdg;
      setup_postdata( $post );
      if(has_post_thumbnail()) {
        $thumb_id = get_post_thumbnail_id($post->ID);
        $divider = wp_get_attachment_image_src($thumb_id, 'full_hd');
        $divider = $divider[0];
      } else if($alt_image) {
        $divider = $alt_image['sizes']['full_hd'];
      }
      $dishes = get_field('piatti');

      $food_categories = get_terms([
        'taxonomy' => 'product_cat',
        // 'child_of' => $cibo_cat->term_id
      ]);
    ?>
      <section class="current-menu">
        <header class="menu-header">
          <h2 class="menu-title-current">
          <?php if($current_title) {
              echo $current_title;
            } else {
              echo $default_current_title;
            } ?>
          </h2>
          <h3 class="menu-subtitle-current">
            <?php
            if($current_subtitle) {
              echo $current_subtitle;
            } else {
              echo $default_current_subtitle;
            } ?>
          </h3>
        </header>
        <div class="menu-container">
          <?php if($dishes): ?>

            <?php foreach($food_categories as $food_cat) {
              // * ANTIPASTI *
              $query_food = new WP_Query(array(
              	'post_type'      	=> 'product',
              	'posts_per_page'	=> -1,
              	'post__in'			=> $dishes,
              	'post_status'		=> 'any',
              	'orderby'        	=> 'post__in',
                'tax_query' => array(
              		array(
              			'taxonomy' => 'product_cat',
              			'field'    => 'slug',
              			'terms'    => $food_cat->slug,
              		),
              	),
              ));
              if ($query_food->have_posts()) :
                echo '<section class="food-area" data-mh>';
                  echo '<h4 class="food-area-title">'.$food_cat->name.'</h4>';
                  echo '<ul class="dishes">';
                  while($query_food->have_posts()) : $query_food->the_post();
                    $product = wc_get_product( get_the_ID());
                    echo '<li>';
                      the_title();
                      echo '<span class="price">€ '.$product->get_price().'</span>';
                    echo '</li>';
                  endwhile;
                  echo '</ul>';
                echo '</section>';
              endif;
              wp_reset_query();
            } ?>

          <?php endif; ?>
        </div>
        <?php if($disclaimer) echo '<div class="disclaimer">'.$disclaimer.'</div>';?>
      </section>

      <figure class="divider-bg">
        <img src="<?= $divider ?>" />
      </figure>
      <?php endif; wp_reset_postdata();?>

    <!-- * NEXT MENU * -->
    <?php
      if($next_mdg) :
      $post = $next_mdg;
      setup_postdata( $post );
      $dishes_next = get_field('piatti');
    ?>
      <section class="next-menu">
        <header class="menu-header">
            <h2 class="menu-title-next">
            <?php if($next_title) {
                echo $next_title;
              } else {
                echo $default_next_title;
              } ?>
            </h2>
            <h3 class="menu-subtitle-next">
              <?php
              if($next_subtitle) {
                echo $next_subtitle;
              } else {
                echo $default_next_subtitle;
              } ?>
            </h3>
          </header>
          <div class="menu-container">
            <?php if($dishes_next): ?>

              <?php foreach($food_categories as $food_cat) {
                // * ANTIPASTI *
                $query_next_food = new WP_Query(array(
                	'post_type'      	=> 'product',
                	'posts_per_page'	=> -1,
                	'post__in'			=> $dishes_next,
                	'post_status'		=> 'any',
                	'orderby'        	=> 'post__in',
                  'tax_query' => array(
                		array(
                			'taxonomy' => 'product_cat',
                			'field'    => 'slug',
                			'terms'    => $food_cat->slug,
                		),
                	),
                ));
                if ($query_next_food->have_posts()) :
                  echo '<section class="food-area" data-mh>';
                    echo '<h4 class="food-area-title">'.$food_cat->name.'</h4>';
                    echo '<ul class="dishes">';
                    while($query_next_food->have_posts()) : $query_next_food->the_post();
                      $product = wc_get_product( get_the_ID());
                      echo '<li>';
                        the_title();
                        echo '<span class="price">€ '.$product->get_price().'</span>';
                      echo '</li>';
                    endwhile;
                    echo '</ul>';
                  echo '</section>';
                endif;
                wp_reset_query();
              } ?>

            <?php endif; ?>
          </div>
      </section>
    <?php endif; wp_reset_postdata(); ?>

    <?php
      if($activate_image_next && $alt_image_next):
    ?>
    <div class="alternative-bg-next">
      <div class="swiper-container">
        <figure class="next-carousel swiper-wrapper">
          <?php foreach($alt_image_next as $img):?>
            <div class="swiper-slide">
              <img src="<?= $img['sizes']['full_hd'] ?>" />
            </div>
          <?php endforeach; ?>
        </figure>
      </div>
    </div>
    <?php endif; ?>

  </div>
<?php endif;?>

<?php get_footer('empty'); ?>

<script>
  setInterval(function() {
    jQuery.ajax(
      {
        url: window.location.href,
        success: function(result) {
          window.location.reload();
        }
      }
    );
  }, 600000); // 10 minutes
</script>
