<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.emberware.it
 * @since             1.0.0
 * @package           Cart_jump
 *
 * @wordpress-plugin
 * Plugin Name:       EW Cart Jump
 * Plugin URI:        https://www.emberware.it
 * Description:       Jump the cart and go directly to the checkout
 * Version:           1.0.0
 * Author:            Emberware
 * Author URI:        https://www.emberware.it
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       thor
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

add_filter( 'woocommerce_add_to_cart_validation', 'ew_remove_cart_item_before_add_to_cart', 20, 3 );
function ew_remove_cart_item_before_add_to_cart( $passed, $product_id, $quantity ) {
    if( ! WC()->cart->is_empty() )
        WC()->cart->empty_cart();
    return $passed;
}

add_filter('woocommerce_add_to_cart_redirect', 'ew_redirect_add_to_cart', 10, 2);
function ew_redirect_add_to_cart() {
   return WC()->cart->get_checkout_url();
}

// add_action(
// 	'woocommerce_init',
// 	function() {
// 		woocommerce_register_additional_checkout_field(
// 			[
// 				'id'            => 'ew/billing_cod_fisc',
// 				'label'         => 'Codice Fiscale',
// 				'optionalLabel' => '',
// 				'location'      => 'address',
// 				'required'      => true,
// 				'attributes'    => [
// 					'autocomplete'     => 'tax-code',
// 					'aria-describedby' => 'some-element',
// 					'aria-label'       => 'custom aria label',
// 					'pattern'          => '[A-Za-z]{6}[0-9]{2}[A-Za-z]{1}[0-9]{2}[A-Za-z]{1}[0-9]{3}[A-Za-z]{1}', // [A-Z]{6}[0-9]{2}[A-Z][0-9]{2}[A-Z][0-9]{3}[A-Z]     [A-Z0-9]{5} A 5-character string of capital letters and numbers.
// 					'title'            => '', //Title to show on hover
// 					'data-custom'      => '', //custom data
// 				],
// 			]
// 		);
// 	}
// );

// add_action(
// 	'woocommerce_init',
// 	function() {
// 		woocommerce_register_additional_checkout_field(
// 			[
// 				'id'            => 'ew/billing_partita_iva',
// 				'label'         => 'Partita Iva',
// 				'location'      => 'address',
// 			]
// 		);
// 	}
// );