<?php
class Ingredient
{
	public function __construct()
    {
        add_action( 'init', array($this, 'ingredient'), 0 );
	}

    public function ingredient()
    {
        $labels = array(
            'name'                       => _x( 'Ingredienti', 'Taxonomy General Name', 'easy_gourmet' ),
            'singular_name'              => _x( 'Ingrediente', 'Taxonomy Singular Name', 'easy_gourmet' ),
            'menu_name'                  => __( 'Ingredienti', 'easy_gourmet' ),
            'all_items'                  => __( 'All Items', 'easy_gourmet' ),
            'parent_item'                => __( 'Parent Item', 'easy_gourmet' ),
            'parent_item_colon'          => __( 'Parent Item:', 'easy_gourmet' ),
            'new_item_name'              => __( 'New Item Name', 'easy_gourmet' ),
            'add_new_item'               => __( 'Add New Item', 'easy_gourmet' ),
            'edit_item'                  => __( 'Edit Item', 'easy_gourmet' ),
            'update_item'                => __( 'Update Item', 'easy_gourmet' ),
            'view_item'                  => __( 'View Item', 'easy_gourmet' ),
            'separate_items_with_commas' => __( 'Separate items with commas', 'easy_gourmet' ),
            'add_or_remove_items'        => __( 'Add or remove items', 'easy_gourmet' ),
            'choose_from_most_used'      => __( 'Choose from the most used', 'easy_gourmet' ),
            'popular_items'              => __( 'Popular Items', 'easy_gourmet' ),
            'search_items'               => __( 'Search Items', 'easy_gourmet' ),
            'not_found'                  => __( 'Not Found', 'easy_gourmet' ),
            'no_terms'                   => __( 'No items', 'easy_gourmet' ),
            'items_list'                 => __( 'Items list', 'easy_gourmet' ),
            'items_list_navigation'      => __( 'Items list navigation', 'easy_gourmet' ),
        );
        $args = array(
            'labels'                     => $labels,
            'hierarchical'               => false,
            'public'                     => true,
            'show_ui'                    => true,
            'show_admin_column'          => true,
            'show_in_nav_menus'          => true,
            'show_tagcloud'              => true,
        );
        register_taxonomy( 'ingredient', array( 'post' ), $args );
    }
}
